/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.array.ArraySummationFunctions;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class ArrayAvgFunction {
    public static final String NAME = "array_avg";

    @Nullable
    private static Float avgFloat(List<Float> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        long size = values.stream().filter(Objects::nonNull).count();
        Float sum = ArraySummationFunctions.sumFloat(values);
        return sum == null ? null : Float.valueOf(sum.floatValue() / (float)size);
    }

    @Nullable
    private static Double avgDouble(List<Double> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        long size = values.stream().filter(Objects::nonNull).count();
        Double sum = ArraySummationFunctions.sumDouble(values);
        return sum == null ? null : Double.valueOf(sum / (double)size);
    }

    @Nullable
    private static BigDecimal avgBigDecimal(List<BigDecimal> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        long size = values.stream().filter(Objects::nonNull).count();
        BigDecimal sum = ArraySummationFunctions.sumBigDecimal(values);
        return sum == null ? null : sum.divide(BigDecimal.valueOf(size), MathContext.DECIMAL128);
    }

    @Nullable
    private static Number avgNumber(List<? extends Number> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        long size = values.stream().filter(Objects::nonNull).count();
        BigDecimal sum = ArraySummationFunctions.sumNumberWithOverflow(values);
        return sum == null ? null : sum.divide(BigDecimal.valueOf(size), MathContext.DECIMAL128);
    }

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(new ArrayType<BigDecimal>(DataTypes.NUMERIC).getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new Scalar<Object, Object>(signature, boundSignature){

            @Override
            @SafeVarargs
            public final Object evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Object> ... args) {
                return ArrayAvgFunction.avgBigDecimal((List<BigDecimal>)new ArrayType<BigDecimal>(DataTypes.NUMERIC).sanitizeValue(args[0].value()));
            }
        });
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(new ArrayType<Float>(DataTypes.FLOAT).getTypeSignature()).returnType(DataTypes.FLOAT.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new Scalar<Object, Object>(signature, boundSignature){

            @Override
            @SafeVarargs
            public final Object evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Object> ... args) {
                return ArrayAvgFunction.avgFloat((List<Float>)new ArrayType<Float>(DataTypes.FLOAT).sanitizeValue(args[0].value()));
            }
        });
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(new ArrayType<Double>(DataTypes.DOUBLE).getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new Scalar<Object, Object>(signature, boundSignature){

            @Override
            @SafeVarargs
            public final Object evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Object> ... args) {
                return ArrayAvgFunction.avgDouble((List<Double>)new ArrayType<Double>(DataTypes.DOUBLE).sanitizeValue(args[0].value()));
            }
        });
        for (final DataType<? extends Number> supportedType : DataTypes.NUMERIC_PRIMITIVE_TYPES) {
            if (supportedType == DataTypes.FLOAT || supportedType == DataTypes.DOUBLE) continue;
            builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(new ArrayType<Number>(supportedType).getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new Scalar<Object, Object>(signature, boundSignature){

                @Override
                @SafeVarargs
                public final Object evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Object> ... args) {
                    return ArrayAvgFunction.avgNumber((List<? extends Number>)new ArrayType(supportedType).sanitizeValue(args[0].value()));
                }
            });
        }
    }
}

