/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.array.ArrayArgumentValidators;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.math.BigDecimal;
import java.util.List;

public class ArrayMinFunction<T>
extends Scalar<T, List<T>> {
    public static final String NAME = "array_min";
    private final DataType<T> dataType;

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(new ArrayType<BigDecimal>(DataTypes.NUMERIC).getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), ArrayMinFunction::new);
        for (DataType<?> supportedType : DataTypes.PRIMITIVE_TYPES) {
            module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(new ArrayType(supportedType).getTypeSignature()).returnType(supportedType.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), ArrayMinFunction::new);
        }
    }

    private ArrayMinFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        this.dataType = signature.getReturnType().createType();
        ArrayArgumentValidators.ensureInnerTypeIsNotUndefined(boundSignature.argTypes(), signature.getName().name());
    }

    @Override
    @SafeVarargs
    public final T evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<T>> ... args) {
        List values = (List)args[0].value();
        if (values == null || values.isEmpty()) {
            return null;
        }
        Object min = values.get(0);
        for (int i = 1; i < values.size(); ++i) {
            Object item = values.get(i);
            if (item == null) continue;
            if (min == null) {
                min = item;
                continue;
            }
            if (this.dataType.compare(item, min) >= 0) continue;
            min = item;
        }
        return (T)min;
    }
}

