/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.ArrayType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.List;

public class ArraySetFunction
extends Scalar<List<Object>, Object> {
    public static final String NAME = "array_set";

    public static void register(Functions.Builder module) {
        TypeSignature arrayESignature = TypeSignature.parse("array(E)");
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(arrayESignature, new ArrayType<Integer>(DataTypes.INTEGER).getTypeSignature(), arrayESignature).returnType(arrayESignature).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), ArraySetFunction::new);
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(arrayESignature, DataTypes.INTEGER.getTypeSignature(), TypeSignature.parse("E")).returnType(arrayESignature).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), SingleArraySetFunction::new);
    }

    public ArraySetFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final List<Object> evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Object> ... args) {
        List inputArray = (List)args[0].value();
        if (inputArray == null) {
            return null;
        }
        List indexesToUpdate = (List)args[1].value();
        List targetValues = (List)args[2].value();
        if (indexesToUpdate == null && targetValues == null) {
            return inputArray;
        }
        ArrayList<Object> updated = new ArrayList<Object>(inputArray);
        if (indexesToUpdate == null || targetValues == null || indexesToUpdate.size() != targetValues.size()) {
            throw new IllegalArgumentException("`array_set(array, indexes, values)`: the size of indexes and values must match or both be nulls");
        }
        for (int i = 0; i < indexesToUpdate.size(); ++i) {
            ArraySetFunction.setElement(updated, (Integer)indexesToUpdate.get(i), targetValues.get(i));
        }
        return updated;
    }

    private static void setElement(List<Object> source, int index, Object value) {
        if (index <= 0) {
            throw new UnsupportedOperationException("Updating arrays with indexes <= 0 is not supported");
        }
        if (--index < source.size()) {
            source.set(index, value);
        } else {
            for (int i = source.size(); i < index; ++i) {
                source.add(null);
            }
            source.add(value);
        }
    }

    static class SingleArraySetFunction
    extends Scalar<List<Object>, Object> {
        SingleArraySetFunction(Signature signature, BoundSignature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        @SafeVarargs
        public final List<Object> evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Object> ... args) {
            List array = (List)args[0].value();
            if (array == null) {
                return null;
            }
            Integer index = (Integer)args[1].value();
            if (index == null) {
                return null;
            }
            Object newValue = args[2].value();
            ArraySetFunction.setElement(array, index, newValue);
            return array;
        }
    }
}

