/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.Locale;

public class FormatFunction
extends Scalar<String, Object> {
    public static final String NAME = "format";
    public static final Signature SIGNATURE = Signature.builder("format", FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), TypeSignature.parse("E")).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).typeVariableConstraints(TypeVariableConstraint.typeVariableOfAnyType("E")).setVariableArity(true).build();

    public static void register(Functions.Builder module) {
        module.add(SIGNATURE, FormatFunction::new);
    }

    public FormatFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        assert (args.length > 1) : "number of args must be > 1";
        Object arg0Value = args[0].value();
        assert (arg0Value != null) : "1st argument must not be null";
        Object[] values = new Object[args.length - 1];
        for (int i = 0; i < args.length - 1; ++i) {
            Object value;
            values[i] = value = args[i + 1].value();
        }
        return String.format(Locale.ENGLISH, (String)arg0Value, values);
    }
}

