/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.function.BiFunction;
import org.joda.time.Period;
import org.joda.time.PeriodType;

public class IntervalArithmeticFunctions {
    public static void register(Functions.Builder module) {
        module.add(Signature.builder("add", FunctionType.SCALAR).argumentTypes(DataTypes.INTERVAL.getTypeSignature(), DataTypes.INTERVAL.getTypeSignature()).returnType(DataTypes.INTERVAL.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new IntervalIntervalArithmeticScalar(Period::plus, (Signature)signature, (BoundSignature)boundSignature));
        module.add(Signature.builder("subtract", FunctionType.SCALAR).argumentTypes(DataTypes.INTERVAL.getTypeSignature(), DataTypes.INTERVAL.getTypeSignature()).returnType(DataTypes.INTERVAL.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new IntervalIntervalArithmeticScalar(Period::minus, (Signature)signature, (BoundSignature)boundSignature));
        module.add(Signature.builder("multiply", FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature(), DataTypes.INTERVAL.getTypeSignature()).returnType(DataTypes.INTERVAL.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), MultiplyIntervalByIntegerScalar::new);
        module.add(Signature.builder("multiply", FunctionType.SCALAR).argumentTypes(DataTypes.INTERVAL.getTypeSignature(), DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.INTERVAL.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), MultiplyIntervalByIntegerScalar::new);
    }

    private static class IntervalIntervalArithmeticScalar
    extends Scalar<Period, Object> {
        private final BiFunction<Period, Period, Period> operation;

        IntervalIntervalArithmeticScalar(BiFunction<Period, Period, Period> operation, Signature signature, BoundSignature boundSignature) {
            super(signature, boundSignature);
            this.operation = operation;
        }

        @Override
        public Period evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
            Period fst = (Period)args[0].value();
            Period snd = (Period)args[1].value();
            if (fst == null || snd == null) {
                return null;
            }
            return this.operation.apply(fst, snd);
        }
    }

    private static class MultiplyIntervalByIntegerScalar
    extends Scalar<Period, Object> {
        private final int integerIdx;
        private final int periodIdx;

        MultiplyIntervalByIntegerScalar(Signature signature, BoundSignature boundSignature) {
            super(signature, boundSignature);
            DataType<?> firstArgType = boundSignature.argTypes().get(0);
            if (firstArgType.id() == 17) {
                this.periodIdx = 0;
                this.integerIdx = 1;
            } else {
                this.periodIdx = 1;
                this.integerIdx = 0;
            }
        }

        @Override
        public Period evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
            Integer integer = (Integer)args[this.integerIdx].value();
            Period period = (Period)args[this.periodIdx].value();
            if (integer == null || period == null) {
                return null;
            }
            return period.multipliedBy(integer.intValue()).normalizedStandard(PeriodType.yearMonthDayTime());
        }
    }
}

