/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import ch.obermuhlner.math.big.BigDecimalMath;
import io.crate.data.Input;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.math.BigDecimal;
import java.math.MathContext;

public abstract class LogFunction
extends Scalar<Number, Number> {
    public static final String NAME = "log";

    public static void register(Functions.Builder module) {
        LogBaseFunction.registerLogBaseFunctions(module);
        Log10Function.registerLog10Functions(module);
        LnFunction.registerLnFunctions(module);
    }

    LogFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    Double validateArgument(Double argument, String caller) {
        if (argument == null) {
            return null;
        }
        if (argument == 0.0) {
            throw new IllegalArgumentException(caller + ": given arguments would result in: '-Infinity'");
        }
        if (argument < 0.0) {
            throw new IllegalArgumentException(caller + ": given arguments would result in: 'NaN'");
        }
        return argument;
    }

    static BigDecimal validateArgument(BigDecimal argument, String caller) {
        if (argument == null) {
            return null;
        }
        if (argument.compareTo(BigDecimal.ZERO) == 0) {
            throw new IllegalArgumentException(caller + ": given arguments would result in: '-Infinity'");
        }
        if (argument.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException(caller + ": given arguments would result in: 'NaN'");
        }
        return argument;
    }

    static class LogBaseFunction
    extends LogFunction {
        static void registerLogBaseFunctions(Functions.Builder builder) {
            builder.add(Signature.builder(LogFunction.NAME, FunctionType.SCALAR).argumentTypes(DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()).returnType(TypeSignature.parse("double precision")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), LogBaseFunction::new);
        }

        LogBaseFunction(Signature signature, BoundSignature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        public Number evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Number> ... args) {
            assert (args.length == 2) : "number of args must be 2";
            Number value1 = (Number)args[0].value();
            Number value2 = (Number)args[1].value();
            if (value1 == null || value2 == null) {
                return null;
            }
            double value = value1.doubleValue();
            this.validateArgument(value, "log(x, b)");
            double base = value2.doubleValue();
            this.validateArgument(base, "log(x, b)");
            double baseResult = Math.log(base);
            if (baseResult == 0.0) {
                throw new IllegalArgumentException("log(x, b): given 'base' would result in a division by zero.");
            }
            return Math.log(value) / baseResult;
        }
    }

    static class Log10Function
    extends LogFunction {
        static void registerLog10Functions(Functions.Builder builder) {
            builder.add(Signature.builder(LogFunction.NAME, FunctionType.SCALAR).argumentTypes(DataTypes.DOUBLE.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), Log10Function::new);
            builder.add(Signature.builder(LogFunction.NAME, FunctionType.SCALAR).argumentTypes(DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, ignoredBoundSignature) -> new UnaryScalar<BigDecimal, BigDecimal>((Signature)signature, BoundSignature.sameAsUnbound(signature), DataTypes.NUMERIC, x -> BigDecimalMath.log10((BigDecimal)Log10Function.validateArgument(x, "log(x)"), (MathContext)MathContext.DECIMAL128)));
        }

        Log10Function(Signature signature, BoundSignature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        public Number evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Number> ... args) {
            assert (args.length == 1) : "number of args must be 1";
            Number value = (Number)args[0].value();
            if (value == null) {
                return null;
            }
            return this.evaluate(value.doubleValue());
        }

        protected Double evaluate(double value) {
            return Math.log10(this.validateArgument(value, "log(x)"));
        }
    }

    public static class LnFunction
    extends Log10Function {
        public static final String NAME = "ln";

        static void registerLnFunctions(Functions.Builder builder) {
            builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.DOUBLE.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), LnFunction::new);
            builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, ignoredBoundSignature) -> new UnaryScalar<BigDecimal, BigDecimal>((Signature)signature, BoundSignature.sameAsUnbound(signature), DataTypes.NUMERIC, x -> BigDecimalMath.log((BigDecimal)LnFunction.validateArgument(x, "ln(x)"), (MathContext)MathContext.DECIMAL128)));
        }

        LnFunction(Signature signature, BoundSignature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        protected Double evaluate(double value) {
            return Math.log(this.validateArgument(value, "ln(x)"));
        }
    }
}

