/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.Strings;

public final class ParseURLFunction
extends Scalar<Object, String> {
    private static final String NAME = "parse_url";

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature()).returnType(DataTypes.UNTYPED_OBJECT.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), ParseURLFunction::new);
    }

    public ParseURLFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String> ... args) {
        String url = (String)args[0].value();
        if (url == null) {
            return null;
        }
        return this.parseURL(url);
    }

    private final Object parseURL(String urlText) {
        HashMap<String, Object> urlMap = new HashMap<String, Object>();
        URL url = null;
        try {
            url = URL.of(new URI(urlText), null);
        }
        catch (MalformedURLException | URISyntaxException e1) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "unable to parse url %s", urlText));
        }
        urlMap.put("scheme", url.getProtocol());
        urlMap.put("userinfo", this.decodeText(url.getUserInfo()));
        urlMap.put("hostname", url.getHost());
        urlMap.put("port", url.getPort() == -1 ? null : Integer.valueOf(url.getPort()));
        urlMap.put("path", this.decodeText(url.getPath()));
        urlMap.put("query", this.decodeText(url.getQuery()));
        urlMap.put("parameters", this.parseQuery(url.getQuery()));
        urlMap.put("fragment", this.decodeText(url.getRef()));
        return urlMap;
    }

    private final Map<String, List<String>> parseQuery(String query) {
        String[] parameters;
        if (Strings.isNullOrEmpty(query)) {
            return null;
        }
        HashMap<String, List<String>> queryMap = new HashMap<String, List<String>>();
        for (String parameter : parameters = query.split("&(?!amp)")) {
            int idx = parameter.indexOf("=");
            String key = idx > 0 ? this.decodeText(parameter.substring(0, idx)) : this.decodeText(parameter);
            String value = idx > 0 && parameter.length() > idx + 1 ? this.decodeText(parameter.substring(idx + 1)) : null;
            queryMap.computeIfAbsent(key, k -> new ArrayList()).add(value);
        }
        return queryMap;
    }

    private final String decodeText(String text) {
        return text != null ? URLDecoder.decode(text, StandardCharsets.UTF_8) : null;
    }
}

