/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.sql.Identifiers;
import io.crate.types.DataTypes;
import org.jetbrains.annotations.VisibleForTesting;

public final class QuoteIdentFunction {
    private static final FunctionName FQNAME = new FunctionName("pg_catalog", "quote_ident");

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(FQNAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature()).returnType(DataTypes.STRING.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar<String, String>((Signature)signature, (BoundSignature)boundSignature, DataTypes.STRING, QuoteIdentFunction::maybeQuoteExpression));
    }

    @VisibleForTesting
    static String maybeQuoteExpression(String expression) {
        int length = expression.length();
        if (length == 0) {
            return "\"\"";
        }
        if (Identifiers.isKeyWord((String)expression)) {
            return "\"" + expression + "\"";
        }
        StringBuilder sb = new StringBuilder();
        boolean addQuotes = false;
        int subscriptStartPos = -1;
        for (int i = 0; i < length; ++i) {
            char c = expression.charAt(i);
            if (c == '\"') {
                sb.append('\"');
            }
            sb.append(c);
            if (subscriptStartPos != -1) continue;
            if (c == '[' && i + 1 < length && expression.charAt(i + 1) == '\'') {
                subscriptStartPos = i;
                continue;
            }
            addQuotes = addQuotes || QuoteIdentFunction.charIsOutsideSafeRange(i, c);
        }
        if (addQuotes) {
            sb.insert(0, '\"');
            if (subscriptStartPos == -1) {
                sb.append('\"');
            } else {
                sb.insert(subscriptStartPos + 1, '\"');
            }
        }
        return sb.toString();
    }

    private static boolean charIsOutsideSafeRange(int i, char c) {
        if (i == 0) {
            return c != '_' && (c < 'a' || c > 'z');
        }
        return !(c == '_' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9');
    }
}

