/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.timestamp;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Locale;

public class TimezoneFunction
extends Scalar<Long, Object> {
    public static final String NAME = "timezone";
    private static final ZoneId UTC = ZoneId.of("UTC");
    private final DataType<?> returnType;

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.TIMESTAMPZ.getTypeSignature()).returnType(DataTypes.TIMESTAMP.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), TimezoneFunction::new);
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.TIMESTAMP.getTypeSignature()).returnType(DataTypes.TIMESTAMPZ.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), TimezoneFunction::new);
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.LONG.getTypeSignature()).returnType(DataTypes.TIMESTAMPZ.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), TimezoneFunction::new);
    }

    private TimezoneFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        this.returnType = boundSignature.returnType();
    }

    @Override
    public Long evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        ZoneId zoneId;
        assert (args.length == 2) : String.format(Locale.ENGLISH, "number of arguments must be 2, got %d instead", args.length);
        String zoneStr = (String)args[0].value();
        if (zoneStr == null) {
            return null;
        }
        try {
            zoneId = ZoneId.of(zoneStr);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "time zone \"%s\" not recognized", zoneStr));
        }
        Number utcTimestamp = (Number)args[1].value();
        if (utcTimestamp == null) {
            return null;
        }
        Instant instant = Instant.ofEpochMilli(utcTimestamp.longValue());
        boolean paramHadTimezone = this.returnType == DataTypes.TIMESTAMP;
        ZoneId srcZoneId = paramHadTimezone ? zoneId : UTC;
        ZoneId dstZoneId = paramHadTimezone ? UTC : zoneId;
        ZonedDateTime zonedDateTime = instant.atZone(srcZoneId).withZoneSameLocal(dstZoneId);
        return zonedDateTime.toInstant().toEpochMilli();
    }
}

