/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.SysColumns;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class FetchMarker
implements Symbol {
    private final RelationName relationName;
    private final List<Reference> fetchRefs;
    private final Reference fetchId;

    public FetchMarker(RelationName relationName, List<Reference> fetchRefs) {
        this(relationName, fetchRefs, SysColumns.forTable(relationName, SysColumns.FETCHID));
    }

    public FetchMarker(RelationName relationName, List<Reference> fetchRefs, Reference fetchId) {
        this.relationName = relationName;
        this.fetchRefs = fetchRefs;
        this.fetchId = fetchId;
    }

    public List<Reference> fetchRefs() {
        return this.fetchRefs;
    }

    public RelationName relationName() {
        return this.relationName;
    }

    public Reference fetchId() {
        return this.fetchId;
    }

    @Override
    public boolean any(Predicate<? super Symbol> predicate) {
        return predicate.test(this) || this.fetchId.any(predicate);
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.REFERENCE;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitFetchMarker(this, context);
    }

    @Override
    public DataType<?> valueType() {
        return this.fetchId.valueType();
    }

    public String toString() {
        return this.toString(Style.UNQUALIFIED);
    }

    @Override
    public String toString(Style style) {
        if (this.relationName.schema() == null) {
            return this.relationName.sqlFqn() + "." + this.fetchId.toString(style);
        }
        return this.fetchId.toString(style);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.fetchId.writeTo(out);
    }

    public long ramBytesUsed() {
        return this.fetchId.ramBytesUsed() + RamUsageEstimator.sizeOf((String)this.relationName.schema()) + RamUsageEstimator.sizeOf((String)this.relationName.name());
    }
}

