/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.symbol.FetchMarker;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.Reference;
import io.crate.types.DataType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class FetchStub
implements Symbol {
    private final FetchMarker fetchMarker;
    private final Reference ref;

    public FetchStub(FetchMarker fetchMarker, Reference ref) {
        this.fetchMarker = fetchMarker;
        this.ref = ref;
    }

    public FetchMarker fetchMarker() {
        return this.fetchMarker;
    }

    public Reference ref() {
        return this.ref;
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.FETCH_STUB;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitFetchStub(this, context);
    }

    @Override
    public DataType<?> valueType() {
        return this.ref.valueType();
    }

    public String toString() {
        return this.toString(Style.UNQUALIFIED);
    }

    @Override
    public String toString(Style style) {
        return this.ref.toString(style);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedEncodingException("Cannot stream FetchStub. This is a planning symbol and not suitable for the execution layer");
    }

    public long ramBytesUsed() {
        return this.ref.ramBytesUsed() + this.fetchMarker.ramBytesUsed();
    }
}

