/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.IntegerType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class InputColumn
implements Symbol,
Comparable<InputColumn> {
    private final DataType<?> dataType;
    private final int index;

    public static List<Symbol> mapToInputColumns(List<DataType<?>> dataTypes) {
        ArrayList<Symbol> inputColumns = new ArrayList<Symbol>(dataTypes.size());
        for (int i = 0; i < dataTypes.size(); ++i) {
            inputColumns.add(new InputColumn(i, dataTypes.get(i)));
        }
        return inputColumns;
    }

    public static List<Symbol> mapToInputColumns(Collection<? extends Symbol> symbols) {
        ArrayList<Symbol> inputColumns = new ArrayList<Symbol>(symbols.size());
        int idx = 0;
        for (Symbol symbol : symbols) {
            inputColumns.add(new InputColumn(idx, symbol.valueType()));
            ++idx;
        }
        return inputColumns;
    }

    public InputColumn(int index, @Nullable DataType<?> dataType) {
        assert (index >= 0) : "index must be >= 0";
        this.index = index;
        this.dataType = Objects.requireNonNullElse(dataType, DataTypes.UNDEFINED);
    }

    public InputColumn(StreamInput in) throws IOException {
        this.index = in.readVInt();
        this.dataType = DataTypes.fromStream(in);
    }

    public InputColumn(int index) {
        this(index, null);
    }

    public int index() {
        return this.index;
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.INPUT_COLUMN;
    }

    @Override
    public DataType<?> valueType() {
        return this.dataType;
    }

    public String toString() {
        return "INPUT(" + this.index + ")";
    }

    @Override
    public String toString(Style style) {
        return "INPUT(" + this.index + ")";
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitInputColumn(this, context);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.index);
        DataTypes.toStream(this.dataType, out);
    }

    @Override
    public int compareTo(InputColumn o) {
        return Integer.compare(this.index, o.index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputColumn that = (InputColumn)o;
        return this.index == that.index;
    }

    public int hashCode() {
        return this.index;
    }

    public long ramBytesUsed() {
        return (long)IntegerType.INTEGER_SIZE + this.dataType.ramBytesUsed();
    }
}

