/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.data.Input;
import io.crate.expression.symbol.LiteralValueFormatter;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.joda.time.Period;

public class Literal<T>
implements Symbol,
Input<T>,
Comparable<Literal<T>> {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Literal.class);
    private final T value;
    private final DataType<T> type;
    public static final Literal<Object> NULL = new Literal<Object>(DataTypes.UNDEFINED, null);
    public static final Literal<Boolean> BOOLEAN_TRUE = new Literal<Boolean>(DataTypes.BOOLEAN, true);
    public static final Literal<Boolean> BOOLEAN_FALSE = new Literal<Boolean>(DataTypes.BOOLEAN, false);
    public static final Literal<Map<String, Object>> EMPTY_OBJECT = Literal.of(Collections.emptyMap());

    public static Collection<Literal<?>> explodeCollection(Literal<?> collectionLiteral) {
        int size;
        Collection<Object> values;
        if (!DataTypes.isArray(collectionLiteral.valueType())) {
            throw new IllegalArgumentException("collectionLiteral must have have an array type");
        }
        Object literalValue = collectionLiteral.value();
        if (literalValue instanceof Collection) {
            Collection collection = (Collection)literalValue;
            values = collection;
            size = collection.size();
        } else {
            values = Arrays.asList((Object[])literalValue);
            size = ((Object[])literalValue).length;
        }
        ArrayList literals = new ArrayList(size);
        for (Object t : values) {
            literals.add(new Literal(((ArrayType)collectionLiteral.valueType()).innerType(), t));
        }
        return literals;
    }

    public Literal(StreamInput in) throws IOException {
        this.type = DataTypes.fromStream(in);
        this.value = this.type.streamer().readValueFrom(in);
    }

    protected Literal(DataType<T> type, T value) {
        assert (Literal.typeMatchesValue(type, value)) : String.format(Locale.ENGLISH, "value %s is not of type %s", value, type.getName());
        this.type = type;
        this.value = value;
    }

    private static <T> boolean typeMatchesValue(DataType<T> type, T value) {
        if (value == null) {
            return true;
        }
        if (type.id() == 12) {
            Map mapValue = (Map)value;
            ObjectType objectType = (ObjectType)type;
            for (Map.Entry entry : mapValue.entrySet()) {
                DataType<?> innerType = objectType.innerType((String)entry.getKey());
                if (Literal.typeMatchesValue(innerType, entry.getValue())) continue;
                return false;
            }
            Object safeValue = objectType.sanitizeValue(value);
            return safeValue.size() == mapValue.size();
        }
        return Objects.equals(type.sanitizeValue(value), value);
    }

    @Override
    public int compareTo(Literal<T> o) {
        return this.type.compare(this.value, o.value);
    }

    public T value() {
        return this.value;
    }

    public DataType<T> valueType() {
        return this.type;
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.LITERAL;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        LiteralValueFormatter.format(this.value, sb);
        return sb.toString();
    }

    @Override
    public String toString(Style style) {
        return this.toString();
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitLiteral(this, context);
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.type.ramBytesUsed() + this.type.valueBytes(this.value);
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        Class<?> componentType = this.value.getClass().getComponentType();
        if (componentType == null) {
            return this.value.hashCode();
        }
        T t = this.value;
        if (t instanceof Object[]) {
            Object[] values = (Object[])t;
            return Arrays.deepHashCode(values);
        }
        if (componentType == Byte.TYPE) {
            return Arrays.hashCode((byte[])this.value);
        }
        if (componentType == Integer.TYPE) {
            return Arrays.hashCode((int[])this.value);
        }
        if (componentType == Long.TYPE) {
            return Arrays.hashCode((long[])this.value);
        }
        if (componentType == Character.TYPE) {
            return Arrays.hashCode((char[])this.value);
        }
        if (componentType == Short.TYPE) {
            return Arrays.hashCode((short[])this.value);
        }
        if (componentType == Boolean.TYPE) {
            return Arrays.hashCode((boolean[])this.value);
        }
        if (componentType == Double.TYPE) {
            return Arrays.hashCode((double[])this.value);
        }
        if (componentType == Float.TYPE) {
            return Arrays.hashCode((float[])this.value);
        }
        throw new UnsupportedOperationException("Unexpected value: " + String.valueOf(this.value) + ", was a new primitive type added to java?");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Literal literal = (Literal)obj;
        if (this.valueType().equals(literal.valueType())) {
            DataType<T> type = this.valueType();
            return Comparator.nullsFirst(type).compare(this.value, literal.value) == 0;
        }
        return false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        DataTypes.toStream(this.type, out);
        this.type.streamer().writeValueTo(out, this.value);
    }

    public static Literal<Map<String, Object>> of(Map<String, Object> value) {
        return new Literal<Map<String, Object>>(DataTypes.UNTYPED_OBJECT, value);
    }

    public static <T> Literal<List<T>> of(List<T> value, DataType<List<T>> dataType) {
        return new Literal<List<T>>(dataType, value);
    }

    public static Literal<Long> of(Long value) {
        return new Literal<Long>(DataTypes.LONG, value);
    }

    public static Literal<?> ofUnchecked(DataType<?> type, Object value) {
        return new Literal<Object>(type, value);
    }

    public static <T> Literal<T> of(DataType<T> type, T value) {
        return new Literal<T>(type, value);
    }

    public static Literal<Integer> of(Integer value) {
        return new Literal<Integer>(DataTypes.INTEGER, value);
    }

    public static Literal<Short> of(Short value) {
        return new Literal<Short>(DataTypes.SHORT, value);
    }

    public static Literal<String> of(String value) {
        return new Literal<String>(DataTypes.STRING, value);
    }

    public static Literal<Boolean> of(Boolean value) {
        if (value == null) {
            return new Literal<Object>(DataTypes.BOOLEAN, null);
        }
        return value != false ? BOOLEAN_TRUE : BOOLEAN_FALSE;
    }

    public static Literal<BigDecimal> of(BigDecimal value) {
        return new Literal<BigDecimal>(DataTypes.NUMERIC, value);
    }

    public static Literal<Double> of(Double value) {
        return new Literal<Double>(DataTypes.DOUBLE, value);
    }

    public static Literal<Float> of(Float value) {
        return new Literal<Float>(DataTypes.FLOAT, value);
    }

    public static Literal<Period> newInterval(Period value) {
        return new Literal<Period>(DataTypes.INTERVAL, value);
    }
}

