/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.data.Row;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.IntegerType;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ParameterSymbol
implements Symbol {
    private final int index;
    private final DataType<?> boundType;
    private final DataType<?> internalType;

    public ParameterSymbol(int index, DataType<?> type) {
        this(index, type, type);
    }

    private ParameterSymbol(int index, DataType<?> boundType, DataType<?> internalType) {
        this.index = index;
        this.boundType = boundType;
        this.internalType = internalType;
    }

    public ParameterSymbol(StreamInput in) throws IOException {
        this.index = in.readVInt();
        this.boundType = DataTypes.fromStream(in);
        this.internalType = DataTypes.fromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.index);
        DataTypes.toStream(this.boundType, out);
        DataTypes.toStream(this.internalType, out);
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.PARAMETER;
    }

    @Override
    public ParameterSymbol cast(DataType<?> targetType, CastMode ... modes) {
        return new ParameterSymbol(this.index, this.boundType, targetType);
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitParameterSymbol(this, context);
    }

    public DataType<?> getBoundType() {
        if (this.boundType.id() == 0) {
            return this.internalType;
        }
        return this.boundType;
    }

    @Override
    public DataType<?> valueType() {
        return this.internalType;
    }

    public String toString() {
        return "$" + (this.index + 1);
    }

    @Override
    public String toString(Style style) {
        return "$" + (this.index + 1);
    }

    public int index() {
        return this.index;
    }

    public long ramBytesUsed() {
        return (long)IntegerType.INTEGER_SIZE + this.internalType.ramBytesUsed();
    }

    public Object bind(Row params) throws IllegalArgumentException {
        try {
            return params.get(this.index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The query contains a parameter placeholder $%d, but there are only %d parameter values", this.index() + 1, params.numColumns()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterSymbol that = (ParameterSymbol)o;
        return Objects.equals(this.index, that.index) && Objects.equals(this.boundType, that.boundType) && Objects.equals(this.internalType, that.internalType);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.boundType, this.internalType);
    }
}

