/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.fdw.AlterServerRequest;
import io.crate.fdw.ServersMetadata;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.VisibleForTesting;

public final class AlterServerTask
extends AckedClusterStateUpdateTask<AcknowledgedResponse> {
    private final AlterServerRequest request;

    public AlterServerTask(AlterServerRequest request) {
        super(Priority.NORMAL, request);
        this.request = request;
    }

    @Override
    protected AcknowledgedResponse newResponse(boolean acknowledged) {
        return new AcknowledgedResponse(acknowledged);
    }

    @Override
    public ClusterState execute(ClusterState currentState) throws Exception {
        ServersMetadata serversMetadata = currentState.metadata().custom("servers", ServersMetadata.EMPTY);
        String serverName = this.request.name();
        ServersMetadata.Server oldServer = serversMetadata.get(serverName);
        Settings.Builder optionsBuilder = Settings.builder().put(oldServer.options());
        AlterServerTask.processOptions(this.request, optionsBuilder);
        ServersMetadata.Server newServer = serversMetadata.get(serverName).withOptions(optionsBuilder.build());
        ServersMetadata newServersMetadata = serversMetadata.put(serverName, newServer);
        return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("servers", newServersMetadata)).build();
    }

    @VisibleForTesting
    static void processOptions(AlterServerRequest request, Settings.Builder optionsBuilder) {
        String serverName = request.name();
        for (Map.Entry<String, Object> entry : request.optionsAdded().getAsStructuredMap().entrySet()) {
            if (optionsBuilder.get(entry.getKey()) != null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Option `%s` already exists for server `%s`, use SET to change it", entry.getKey(), serverName));
            }
            optionsBuilder.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : request.optionsUpdated().getAsStructuredMap().entrySet()) {
            if (optionsBuilder.get(entry.getKey()) == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Option `%s` does not exist for server `%s`, use ADD to add it", entry.getKey(), serverName));
            }
            optionsBuilder.put(entry.getKey(), entry.getValue());
        }
        for (String option : request.optionsRemoved()) {
            if (optionsBuilder.get(option) == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Option `%s` does not exist for server `%s`", option, serverName));
            }
            optionsBuilder.remove(option);
        }
    }
}

