/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.exceptions.RelationUnknown;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.ForeignCollectPhase;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.sources.CollectSource;
import io.crate.expression.InputFactory;
import io.crate.fdw.ForeignDataWrapper;
import io.crate.fdw.ForeignTable;
import io.crate.fdw.ForeignTablesMetadata;
import io.crate.fdw.JdbcForeignDataWrapper;
import io.crate.fdw.ServersMetadata;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.role.Roles;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

@Singleton
public class ForeignDataWrappers
implements CollectSource {
    public static Setting<Boolean> ALLOW_LOCAL = Setting.boolSetting("fdw.allow_local", false, Setting.Property.NodeScope, Setting.Property.Exposed);
    private final ClusterService clusterService;
    private final InputFactory inputFactory;
    private final Map<String, ForeignDataWrapper> wrappers;
    private final Roles roles;

    @Inject
    public ForeignDataWrappers(Settings settings, ClusterService clusterService, NodeContext nodeContext) {
        this.clusterService = clusterService;
        this.inputFactory = new InputFactory(nodeContext);
        this.wrappers = Map.of("jdbc", new JdbcForeignDataWrapper(settings, this.inputFactory));
        this.roles = nodeContext.roles();
    }

    public boolean contains(String fdw) {
        return this.wrappers.containsKey(fdw);
    }

    public ForeignDataWrapper get(String fdw) {
        ForeignDataWrapper foreignDataWrapper = this.wrappers.get(fdw);
        if (foreignDataWrapper == null) {
            throw new IllegalArgumentException("foreign-data wrapper " + fdw + " does not exist");
        }
        return foreignDataWrapper;
    }

    @Override
    public CompletableFuture<BatchIterator<Row>> getIterator(TransactionContext txnCtx, CollectPhase collectPhase, CollectTask collectTask, boolean supportMoveToStart) {
        if (!(collectPhase instanceof ForeignCollectPhase)) {
            throw new IllegalArgumentException("ForeignDataWrappers requires ForeignCollectPhase, not: " + String.valueOf(collectPhase));
        }
        ForeignCollectPhase phase = (ForeignCollectPhase)collectPhase;
        Metadata metadata = this.clusterService.state().metadata();
        ForeignTablesMetadata foreignTables = (ForeignTablesMetadata)metadata.custom("foreign_tables");
        if (foreignTables == null) {
            throw new RelationUnknown(phase.relationName());
        }
        ForeignTable foreignTable = foreignTables.get(phase.relationName());
        if (foreignTable == null) {
            throw new RelationUnknown(phase.relationName());
        }
        ServersMetadata servers = (ServersMetadata)metadata.custom("servers");
        if (servers == null) {
            throw new ResourceNotFoundException(String.format(Locale.ENGLISH, "Server `%s` not found", foreignTable.server()), new Object[0]);
        }
        ServersMetadata.Server server = servers.get(foreignTable.server());
        ForeignDataWrapper fdw = this.wrappers.get(server.fdw());
        if (fdw == null) {
            throw new ResourceNotFoundException(String.format(Locale.ENGLISH, "Foreign data wrapper '%s' used by server '%s' no longer exists", server.fdw(), foreignTable.server()), new Object[0]);
        }
        String executeAs = phase.executeAs();
        if (executeAs == null) {
            executeAs = txnCtx.sessionSettings().userName();
        }
        return fdw.getIterator(Objects.requireNonNull(this.roles.findUser(executeAs), "current user must exist"), server, foreignTable, txnCtx, collectPhase.toCollect(), phase.query());
    }
}

