/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.WhereClause;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.IndexReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.doc.DocTableInfoFactory;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.TableInfo;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.jetbrains.annotations.Nullable;

public record ForeignTable(RelationName name, Map<ColumnIdent, Reference> references, String server, Settings options) implements Writeable,
TableInfo
{
    ForeignTable(StreamInput in) throws IOException {
        this(new RelationName(in), in.readMap(LinkedHashMap::new, ColumnIdent::of, Reference::fromStream), in.readString(), Settings.readSettingsFromStream(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.name.writeTo(out);
        out.writeMap(this.references, (o, v) -> v.writeTo(o), Reference::toStream);
        out.writeString(this.server);
        Settings.writeSettingsToStream(out, this.options);
    }

    public static ForeignTable fromXContent(NodeContext nodeCtx, RelationName name, XContentParser parser) throws IOException {
        HashMap<ColumnIdent, Reference> references = null;
        String server = null;
        Settings options = null;
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(CoordinatorTxnCtx.systemTransactionContext(), nodeCtx, ParamTypeHints.EMPTY, FieldProvider.UNSUPPORTED, null);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) continue;
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "server": {
                    server = parser.text();
                    continue block10;
                }
                case "options": {
                    options = Settings.fromXContent(parser);
                    continue block10;
                }
                case "references": {
                    references = new HashMap<ColumnIdent, Reference>();
                    HashMap<ColumnIdent, IndexReference.Builder> indexColumns = new HashMap<ColumnIdent, IndexReference.Builder>();
                    Map properties = parser.map();
                    DocTableInfoFactory.parseColumns(expressionAnalyzer, name, null, Map.of(), Set.of(), List.of(), List.of(), properties, indexColumns, references);
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        return new ForeignTable(Objects.requireNonNull(name), Objects.requireNonNull(references), Objects.requireNonNull(server), Objects.requireNonNull(options));
    }

    @Override
    public Collection<Reference> columns() {
        return this.references.values();
    }

    @Override
    public Iterator<Reference> iterator() {
        return this.references.values().iterator();
    }

    @Override
    public RowGranularity rowGranularity() {
        return RowGranularity.DOC;
    }

    @Override
    public RelationName ident() {
        return this.name;
    }

    @Override
    public List<ColumnIdent> primaryKey() {
        return List.of();
    }

    @Override
    public Settings parameters() {
        return Settings.EMPTY;
    }

    @Override
    public Set<Operation> supportedOperations() {
        return EnumSet.of(Operation.READ, Operation.SHOW_CREATE);
    }

    @Override
    public RelationInfo.RelationType relationType() {
        return RelationInfo.RelationType.FOREIGN;
    }

    @Override
    @Nullable
    public Reference getReference(ColumnIdent columnIdent) {
        return this.references.get(columnIdent);
    }

    @Override
    public Routing getRouting(ClusterState state, RoutingProvider routingProvider, WhereClause whereClause, RoutingProvider.ShardSelection shardSelection, CoordinatorSessionSettings sessionSettings) {
        return Routing.forTableOnSingleNode(this.name, state.nodes().getLocalNodeId());
    }

    public Stream<Option> getOptions() {
        return this.options.getAsStructuredMap().entrySet().stream().map(entry -> new Option(this.name, (String)entry.getKey(), DataTypes.STRING.implicitCast(entry.getValue())));
    }

    public record Option(RelationName relationName, String name, String value) {
    }
}

