/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.exceptions.RelationUnknown;
import io.crate.fdw.ForeignTable;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.jetbrains.annotations.Nullable;

public final class ForeignTablesMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom,
Iterable<ForeignTable> {
    public static final String TYPE = "foreign_tables";
    public static final ForeignTablesMetadata EMPTY = new ForeignTablesMetadata(Map.of());
    private final Map<RelationName, ForeignTable> tables;

    ForeignTablesMetadata(Map<RelationName, ForeignTable> tables) {
        this.tables = tables;
    }

    public ForeignTablesMetadata(StreamInput in) throws IOException {
        this.tables = in.readMap(RelationName::new, ForeignTable::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.tables, (o, v) -> v.writeTo(o), (o, v) -> v.writeTo(o));
    }

    public static ForeignTablesMetadata fromXContent(NodeContext nodeCtx, XContentParser parser) throws IOException {
        HashMap<RelationName, ForeignTable> tables = new HashMap<RelationName, ForeignTable>();
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
            assert (parser.currentName().endsWith(TYPE)) : "toXContent starts with startObject(TYPE)";
            parser.nextToken();
        }
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) continue;
            RelationName name = RelationName.fromIndexName(parser.currentName());
            parser.nextToken();
            ForeignTable table = ForeignTable.fromXContent(nodeCtx, name, parser);
            tables.put(name, table);
        }
        parser.nextToken();
        return new ForeignTablesMetadata(tables);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_5_7_0;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY, Metadata.XContentContext.SNAPSHOT);
    }

    public boolean contains(RelationName tableName) {
        return this.tables.containsKey(tableName);
    }

    public ForeignTablesMetadata add(RelationName tableName, Collection<Reference> columns, String server, Settings options) {
        HashMap<RelationName, ForeignTable> newTables = new HashMap<RelationName, ForeignTable>(this.tables);
        ForeignTable value = new ForeignTable(tableName, columns.stream().collect(Collectors.toMap(Reference::column, x -> x)), server, options);
        newTables.put(tableName, value);
        return new ForeignTablesMetadata(newTables);
    }

    @Nullable
    public ForeignTable get(RelationName name) {
        return this.tables.get(name);
    }

    public boolean anyDependOnServer(String serverName) {
        return this.tables.values().stream().anyMatch(x -> x.server().equals(serverName));
    }

    public ForeignTablesMetadata removeAllForServers(List<String> names) {
        HashMap<RelationName, ForeignTable> newTables = new HashMap<RelationName, ForeignTable>();
        for (Map.Entry<RelationName, ForeignTable> entry : this.tables.entrySet()) {
            RelationName relationName = entry.getKey();
            ForeignTable foreignTable = entry.getValue();
            if (names.contains(foreignTable.server())) continue;
            newTables.put(relationName, foreignTable);
        }
        return newTables.size() == this.tables.size() ? this : new ForeignTablesMetadata(newTables);
    }

    public ForeignTablesMetadata remove(List<RelationName> relations, boolean ifExists) {
        HashMap<RelationName, ForeignTable> newTables = new HashMap<RelationName, ForeignTable>(this.tables);
        for (RelationName relation : relations) {
            ForeignTable removed = newTables.remove(relation);
            if (removed != null || ifExists) continue;
            throw new RelationUnknown(relation);
        }
        return newTables.size() == this.tables.size() ? this : new ForeignTablesMetadata(newTables);
    }

    @Override
    public Iterator<ForeignTable> iterator() {
        return this.tables.values().iterator();
    }

    public int hashCode() {
        return this.tables.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ForeignTablesMetadata)) return false;
        ForeignTablesMetadata other = (ForeignTablesMetadata)obj;
        if (!this.tables.equals(other.tables)) return false;
        return true;
    }

    public Iterable<ForeignTable.Option> tableOptions() {
        return () -> this.tables.values().stream().flatMap(table -> table.getOptions()).iterator();
    }
}

