/*
 * Decompiled with CFR 0.152.
 */
package io.crate.geo;

import io.crate.exceptions.UnsupportedFeatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Line;
import org.apache.lucene.geo.Point;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;

public class LatLonShapeUtils {
    public static void createIndexableFields(String name, Object luceneShape, Consumer<? super IndexableField> addField) {
        if (luceneShape instanceof Point) {
            Point point = (Point)luceneShape;
            LatLonShapeUtils.addFields(LatLonShape.createIndexableFields((String)name, (double)point.getLat(), (double)point.getLon()), addField);
        } else if (luceneShape instanceof Line) {
            Line line = (Line)luceneShape;
            LatLonShapeUtils.addFields(LatLonShape.createIndexableFields((String)name, (Line)line), addField);
        } else if (luceneShape instanceof Polygon) {
            Polygon polygon = (Polygon)luceneShape;
            LatLonShapeUtils.addFields(LatLonShape.createIndexableFields((String)name, (Polygon)polygon), addField);
        } else if (luceneShape instanceof Point[]) {
            Point[] points;
            for (Point point : points = (Point[])luceneShape) {
                LatLonShapeUtils.addFields(LatLonShape.createIndexableFields((String)name, (double)point.getLat(), (double)point.getLon()), addField);
            }
        } else if (luceneShape instanceof Line[]) {
            Line[] lines = (Line[])luceneShape;
            for (int i = 0; i < lines.length; ++i) {
                LatLonShapeUtils.addFields(LatLonShape.createIndexableFields((String)name, (Line)lines[i]), addField);
            }
        } else if (luceneShape instanceof Polygon[]) {
            Polygon[] polygons = (Polygon[])luceneShape;
            for (int i = 0; i < polygons.length; ++i) {
                LatLonShapeUtils.addFields(LatLonShape.createIndexableFields((String)name, (Polygon)polygons[i]), addField);
            }
        } else if (luceneShape instanceof Object[]) {
            Object[] collection;
            for (Object o : collection = (Object[])luceneShape) {
                LatLonShapeUtils.createIndexableFields(name, o, addField);
            }
        } else {
            throw new IllegalArgumentException("Invalid shape type found [" + String.valueOf(luceneShape.getClass()) + "] while indexing shape");
        }
    }

    private static void addFields(Field[] indexableFields, Consumer<? super IndexableField> addField) {
        for (Field field : indexableFields) {
            addField.accept((IndexableField)field);
        }
    }

    public static Query newLatLonShapeQuery(String fieldName, ShapeField.QueryRelation relation, Object queryShape) {
        List<LatLonGeometry> geometries = LatLonShapeUtils.collectGeometries(fieldName, queryShape);
        if (relation == ShapeField.QueryRelation.WITHIN && geometries.stream().anyMatch(geometry -> geometry instanceof Line)) {
            throw new UnsupportedFeatureException("WITHIN queries with line geometries are not supported");
        }
        return LatLonShape.newGeometryQuery((String)fieldName, (ShapeField.QueryRelation)relation, (LatLonGeometry[])geometries.toArray(new LatLonGeometry[0]));
    }

    private static List<LatLonGeometry> collectGeometries(String fieldName, Object queryShape) {
        if (queryShape instanceof Line[]) {
            Line[] lines = (Line[])queryShape;
            return Arrays.asList(lines);
        }
        if (queryShape instanceof Polygon[]) {
            Polygon[] polygons = (Polygon[])queryShape;
            return Arrays.asList(polygons);
        }
        if (queryShape instanceof Line) {
            Line line = (Line)queryShape;
            return Collections.singletonList(line);
        }
        if (queryShape instanceof Polygon) {
            Polygon polygon = (Polygon)queryShape;
            return Collections.singletonList(polygon);
        }
        if (queryShape instanceof Point[]) {
            Point[] points = (Point[])queryShape;
            return Arrays.asList(points);
        }
        if (queryShape instanceof Point) {
            Point point = (Point)queryShape;
            return Collections.singletonList(point);
        }
        if (queryShape instanceof Object[]) {
            Object[] collection = (Object[])queryShape;
            ArrayList<LatLonGeometry> geometries = new ArrayList<LatLonGeometry>();
            for (Object shape : collection) {
                geometries.addAll(LatLonShapeUtils.collectGeometries(fieldName, shape));
            }
            return geometries;
        }
        throw new IllegalArgumentException("Unknown shape for field [" + fieldName + "] found");
    }
}

