/*
 * Decompiled with CFR 0.152.
 */
package io.crate.lucene.match;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;

public final class CrateRegexCapabilities {
    static JavaUtilRegexMatcher compile(String regex, int flags) {
        return new JavaUtilRegexMatcher(regex, flags);
    }

    static class JavaUtilRegexMatcher {
        private final Pattern pattern;
        private final Matcher matcher;
        private final CharsRefBuilder utf16 = new CharsRefBuilder();

        JavaUtilRegexMatcher(String regex, int flags) {
            this.pattern = Pattern.compile(regex, flags);
            this.matcher = this.pattern.matcher((CharSequence)this.utf16.get());
        }

        boolean match(BytesRef term) {
            this.utf16.copyUTF8Bytes(term);
            this.utf16.get();
            return this.matcher.reset().matches();
        }
    }
}

