/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.common.collections.Lists;
import io.crate.exceptions.UnsupportedFunctionException;
import io.crate.expression.symbol.Aggregation;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionProvider;
import io.crate.metadata.FunctionType;
import io.crate.metadata.FunctionsProvider;
import io.crate.metadata.SearchPath;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.BoundVariables;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.SignatureBinder;
import io.crate.metadata.pgcatalog.OidHash;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.CompositeClassLoader;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class Functions {
    private static final Logger LOGGER = LogManager.getLogger(Functions.class);
    private volatile Map<FunctionName, List<FunctionProvider>> udfFunctionImplementations = Map.of();
    private final Map<FunctionName, List<FunctionProvider>> functionImplementations;

    public static Functions load(Settings settings, SessionSettingRegistry sessionSettingRegistry, ClassLoader ... classLoaders) {
        Builder builder = new Builder();
        CompositeClassLoader compositeLoader = new CompositeClassLoader(FunctionsProvider.class.getClassLoader(), List.of(classLoaders));
        for (FunctionsProvider provider : ServiceLoader.load(FunctionsProvider.class, compositeLoader)) {
            provider.addFunctions(settings, sessionSettingRegistry, builder);
        }
        return builder.build();
    }

    private Functions(Map<FunctionName, List<FunctionProvider>> functionProvidersByName) {
        this.functionImplementations = functionProvidersByName;
    }

    public Iterable<Signature> signatures() {
        return () -> Stream.concat(this.functionImplementations.values().stream().flatMap(x -> x.stream()).map(x -> x.signature()), this.udfFunctionImplementations.values().stream().flatMap(x -> x.stream()).map(x -> x.signature())).iterator();
    }

    public void setUDFs(Map<FunctionName, List<FunctionProvider>> functions) {
        this.udfFunctionImplementations = functions;
    }

    @Nullable
    public Signature findFunctionSignatureByOid(int oid) {
        for (Signature signature : this.signatures()) {
            if (oid != OidHash.functionOid(signature)) continue;
            return signature;
        }
        return null;
    }

    public FunctionImplementation get(@Nullable String suppliedSchema, String functionName, List<Symbol> arguments, SearchPath searchPath) {
        return this.get(suppliedSchema, functionName, Symbols.typeView(arguments), arguments, searchPath);
    }

    private FunctionImplementation get(@Nullable String suppliedSchema, String functionName, List<DataType<?>> argumentTypes, List<Symbol> arguments, SearchPath searchPath) {
        FunctionName fqnName = new FunctionName(suppliedSchema, functionName);
        FunctionImplementation func = Functions.resolveFunctionBySignature(fqnName, argumentTypes, arguments, searchPath, this.functionImplementations, this.udfFunctionImplementations);
        if (func == null) {
            Functions.raiseUnknownFunction(suppliedSchema, functionName, arguments, List.of());
        }
        return func;
    }

    @Nullable
    private FunctionImplementation get(Signature signature, List<DataType<?>> actualArgumentTypes, DataType<?> actualReturnType, Map<FunctionName, List<FunctionProvider>> candidatesByName) {
        List<FunctionProvider> candidates = candidatesByName.get(signature.getName());
        if (candidates == null) {
            return null;
        }
        for (FunctionProvider candidate : candidates) {
            if (!candidate.signature().equals(signature)) continue;
            BoundSignature boundSignature = new BoundSignature(actualArgumentTypes, actualReturnType);
            return (FunctionImplementation)candidate.factory().apply(signature, boundSignature);
        }
        return null;
    }

    @Nullable
    private static FunctionImplementation resolveFunctionBySignature(FunctionName name, List<DataType<?>> argumentTypes, List<Symbol> arguments, SearchPath searchPath, Map<FunctionName, List<FunctionProvider>> builtInFunctions, Map<FunctionName, List<FunctionProvider>> udfs) {
        List<FunctionProvider> candidates = builtInFunctions.get(name);
        if (candidates == null && name.schema() == null) {
            for (String pathSchema : searchPath) {
                FunctionName searchPathFunctionName = new FunctionName(pathSchema, name.name());
                candidates = builtInFunctions.get(searchPathFunctionName);
                if (candidates == null) {
                    candidates = udfs.get(searchPathFunctionName);
                }
                if (candidates == null) continue;
                break;
            }
        }
        if (candidates == null && (candidates = udfs.get(name)) == null) {
            return null;
        }
        List<FunctionProvider> finalCandidates = candidates;
        assert (candidates.stream().allMatch(f -> f.signature().getBindingInfo() != null)) : "Resolving/Matching of signatures can only be done with non-null signature's binding info";
        Iterable<FunctionProvider> exactCandidates = () -> finalCandidates.stream().filter(function -> function.signature().getBindingInfo().getTypeVariableConstraints().isEmpty()).iterator();
        FunctionImplementation match = Functions.matchFunctionCandidates(exactCandidates, argumentTypes, SignatureBinder.CoercionType.NONE);
        if (match != null) {
            return match;
        }
        Iterable<FunctionProvider> genericCandidates = () -> finalCandidates.stream().filter(function -> !function.signature().getBindingInfo().getTypeVariableConstraints().isEmpty()).iterator();
        match = Functions.matchFunctionCandidates(genericCandidates, argumentTypes, SignatureBinder.CoercionType.NONE);
        if (match != null) {
            return match;
        }
        Iterable<FunctionProvider> candidatesAllowingCoercion = () -> finalCandidates.stream().filter(function -> function.signature().getBindingInfo().isCoercionAllowed()).iterator();
        match = Functions.matchFunctionCandidates(candidatesAllowingCoercion, argumentTypes, SignatureBinder.CoercionType.PRECEDENCE_ONLY);
        if (match != null) {
            return match;
        }
        match = Functions.matchFunctionCandidates(candidatesAllowingCoercion, argumentTypes, SignatureBinder.CoercionType.FULL);
        if (match == null) {
            Functions.raiseUnknownFunction(name.schema(), name.name(), arguments, candidates);
        }
        return match;
    }

    @Nullable
    private static FunctionImplementation matchFunctionCandidates(Iterable<FunctionProvider> candidates, List<DataType<?>> arguments, SignatureBinder.CoercionType coercionType) {
        List<ApplicableFunction> applicableFunctions = new ArrayList<ApplicableFunction>();
        for (FunctionProvider candidate : candidates) {
            BoundSignature boundSignature = new SignatureBinder(candidate.signature(), coercionType).bind(arguments);
            if (boundSignature == null) continue;
            applicableFunctions.add(new ApplicableFunction(candidate.signature(), boundSignature, candidate.factory()));
        }
        if (coercionType != SignatureBinder.CoercionType.NONE) {
            applicableFunctions = Functions.selectMostSpecificFunctions(applicableFunctions, arguments);
            if (LOGGER.isDebugEnabled() && applicableFunctions.isEmpty()) {
                LOGGER.debug("At least single function must be left after selecting most specific one");
            }
        }
        if (applicableFunctions.size() == 1) {
            return ((ApplicableFunction)Lists.getOnlyElement(applicableFunctions)).get();
        }
        if (applicableFunctions.size() > 1 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Multiple candidates match! " + String.valueOf(applicableFunctions));
        }
        return null;
    }

    public FunctionImplementation getQualified(Function function) {
        Signature signature = function.signature();
        return this.getQualified(signature, Symbols.typeView(function.arguments()), function.valueType());
    }

    public FunctionImplementation getQualified(Aggregation function) {
        Signature signature = function.signature();
        return this.getQualified(signature, Symbols.typeView(function.inputs()), function.boundSignatureReturnType());
    }

    public FunctionImplementation getQualified(Signature signature, List<DataType<?>> actualArgumentTypes, DataType<?> actualReturnType) throws UnsupportedFunctionException {
        FunctionImplementation impl = this.get(signature, actualArgumentTypes, actualReturnType, this.functionImplementations);
        if (impl == null) {
            impl = this.get(signature, actualArgumentTypes, actualReturnType, this.udfFunctionImplementations);
        }
        return impl;
    }

    @VisibleForTesting
    static void raiseUnknownFunction(@Nullable String suppliedSchema, String name, List<Symbol> arguments, List<FunctionProvider> candidates) {
        List<DataType<?>> argumentTypes = Symbols.typeView(arguments);
        Function function = new Function(Signature.builder(new FunctionName(suppliedSchema, name), FunctionType.SCALAR).argumentTypes(Lists.map(argumentTypes, DataType::getTypeSignature)).returnType(DataTypes.UNDEFINED.getTypeSignature()).build(), arguments, DataTypes.UNDEFINED);
        String message = "Unknown function: " + function.toString(Style.QUALIFIED);
        if (!candidates.isEmpty()) {
            message = !arguments.isEmpty() ? message + ", no overload found for matching argument types: (" + Lists.joinOn((String)", ", argumentTypes, DataType::toString) + ")." : message + ".";
            message = message + " Possible candidates: " + Lists.joinOn((String)", ", candidates, c -> c.signature().getName().displayName() + "(" + Lists.joinOn((String)", ", c.signature().getArgumentTypes(), TypeSignature::toString) + "):" + c.signature().getReturnType().toString());
        }
        throw new UnsupportedFunctionException(message, suppliedSchema);
    }

    private static List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> applicableFunctions, List<DataType<?>> arguments) {
        if (applicableFunctions.isEmpty()) {
            return applicableFunctions;
        }
        List argumentTypeSignatures = Lists.map(arguments, DataType::getTypeSignature);
        List<ApplicableFunction> mostSpecificFunctions = Functions.selectMostSpecificFunctions(applicableFunctions, (ApplicableFunction l, ApplicableFunction r) -> Functions.hasMoreExactTypeMatches(l, r, argumentTypeSignatures));
        if (mostSpecificFunctions.size() <= 1) {
            return mostSpecificFunctions;
        }
        if ((mostSpecificFunctions = Functions.selectMostSpecificFunctions(mostSpecificFunctions, Functions::isMoreSpecificThan)).size() <= 1) {
            return mostSpecificFunctions;
        }
        if (Functions.returnTypeIsTheSame(mostSpecificFunctions) || arguments.stream().allMatch(s -> s.id() == DataTypes.UNDEFINED.id())) {
            ApplicableFunction selectedFunction = (ApplicableFunction)mostSpecificFunctions.stream().sorted(Comparator.comparing(Objects::toString)).iterator().next();
            return List.of(selectedFunction);
        }
        return mostSpecificFunctions;
    }

    private static List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> candidates, BiFunction<ApplicableFunction, ApplicableFunction, Boolean> isMoreSpecific) {
        ArrayList<ApplicableFunction> representatives = new ArrayList<ApplicableFunction>();
        for (ApplicableFunction current : candidates) {
            boolean addCandidate = true;
            Iterator it = representatives.iterator();
            while (it.hasNext()) {
                ApplicableFunction representative = (ApplicableFunction)it.next();
                if (representative.equals(current)) continue;
                if (isMoreSpecific.apply(current, representative).booleanValue()) {
                    it.remove();
                    addCandidate = true;
                    continue;
                }
                if (!isMoreSpecific.apply(representative, current).booleanValue()) continue;
                addCandidate = false;
            }
            if (!addCandidate) continue;
            representatives.add(current);
        }
        return representatives;
    }

    private static boolean isMoreSpecificThan(ApplicableFunction left, ApplicableFunction right) {
        int rightArgsCount;
        List<DataType<?>> resolvedTypes = left.boundSignature().argTypes();
        BoundVariables boundVariables = SignatureBinder.withPrecedenceOnly(right.signature()).bindVariables(resolvedTypes);
        if (boundVariables == null) {
            return false;
        }
        int leftArgsCount = left.signature().getArgumentTypes().size();
        return leftArgsCount >= (rightArgsCount = right.signature().getArgumentTypes().size());
    }

    private static boolean hasMoreExactTypeMatches(ApplicableFunction left, ApplicableFunction right, List<TypeSignature> actualArgumentTypes) {
        int rightExactMatches;
        int leftExactMatches = Functions.numberOfExactTypeMatches(actualArgumentTypes, left.signature().getArgumentTypes());
        return leftExactMatches > (rightExactMatches = Functions.numberOfExactTypeMatches(actualArgumentTypes, right.signature().getArgumentTypes()));
    }

    private static boolean returnTypeIsTheSame(List<ApplicableFunction> applicableFunctions) {
        Set returnTypes = applicableFunctions.stream().map(function -> function.boundSignature().returnType()).collect(Collectors.toSet());
        return returnTypes.size() == 1;
    }

    private static int numberOfExactTypeMatches(List<TypeSignature> actualArgumentTypes, List<TypeSignature> declaredArgumentTypes) {
        int cnt = 0;
        for (int i = 0; i < actualArgumentTypes.size(); ++i) {
            if (declaredArgumentTypes.size() <= i || !actualArgumentTypes.get(i).equalsIgnoringParameters(declaredArgumentTypes.get(i))) continue;
            ++cnt;
        }
        return cnt;
    }

    public static class Builder {
        private HashMap<FunctionName, ArrayList<FunctionProvider>> providersByName = new HashMap();

        public void add(Signature signature, FunctionProvider.FunctionFactory factory) {
            List functionProviders = this.providersByName.computeIfAbsent(signature.getName(), k -> new ArrayList());
            functionProviders.add(new FunctionProvider(signature, factory));
        }

        public Functions build() {
            for (ArrayList<FunctionProvider> providers : this.providersByName.values()) {
                providers.trimToSize();
            }
            return new Functions(Map.copyOf(this.providersByName));
        }
    }

    private record ApplicableFunction(Signature signature, BoundSignature boundSignature, FunctionProvider.FunctionFactory factory) implements Supplier<FunctionImplementation>
    {
        @Override
        public FunctionImplementation get() {
            return (FunctionImplementation)this.factory.apply(this.signature, this.boundSignature);
        }

        @Override
        public String toString() {
            return "ApplicableFunction{signature=" + String.valueOf(this.signature) + ", boundSignature=" + String.valueOf(this.boundSignature) + "}";
        }
    }
}

