/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.FunctionType;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.SimpleReference;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class GeneratedReference
implements Reference {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(GeneratedReference.class);
    private final Reference ref;
    private final String formattedGeneratedExpression;
    private final Symbol generatedExpression;
    private final List<Reference> referencedReferences;

    public GeneratedReference(Reference ref, Symbol generatedExpression) {
        this(ref, generatedExpression.toString(Style.UNQUALIFIED), generatedExpression);
    }

    private GeneratedReference(Reference ref, String formattedGeneratedExpression, Symbol generatedExpression) {
        assert (generatedExpression != null) : "GeneratedExpression is required";
        assert (generatedExpression.valueType().equals(ref.valueType())) : "The type of the generated expression must match the valueType of the `GeneratedReference`";
        this.ref = ref;
        this.generatedExpression = generatedExpression;
        this.formattedGeneratedExpression = formattedGeneratedExpression;
        if (generatedExpression.hasFunctionType(FunctionType.AGGREGATE)) {
            throw new UnsupportedOperationException("Aggregation functions are not allowed in generated columns: " + String.valueOf(generatedExpression));
        }
        if (generatedExpression.hasFunctionType(FunctionType.TABLE)) {
            throw new UnsupportedOperationException("Cannot use table function in generated expression of column `" + ref.column().fqn() + "`");
        }
        this.referencedReferences = new ArrayList<Reference>();
        generatedExpression.visit(Reference.class, this.referencedReferences::add);
    }

    public GeneratedReference(StreamInput in) throws IOException {
        Version version = in.getVersion();
        this.ref = version.onOrAfter(Version.V_5_0_0) ? Reference.fromStream(in) : new SimpleReference(in);
        this.formattedGeneratedExpression = in.readString();
        this.generatedExpression = version.onOrAfter(Version.V_5_1_0) && version.onOrBefore(Version.V_5_6_0) ? Symbol.nullableFromStream(in) : Symbol.fromStream(in);
        int size = in.readVInt();
        this.referencedReferences = new ArrayList<Reference>(size);
        for (int i = 0; i < size; ++i) {
            this.referencedReferences.add((Reference)Reference.fromStream(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Version version = out.getVersion();
        if (version.onOrAfter(Version.V_5_0_0)) {
            Reference.toStream(out, this.ref);
        } else {
            Reference reference = this.ref;
            if (reference instanceof SimpleReference) {
                SimpleReference simpleRef = (SimpleReference)reference;
                simpleRef.writeTo(out);
            } else {
                SimpleReference simpleReference = new SimpleReference(this.ref.ident(), this.ref.granularity(), this.ref.valueType(), this.ref.indexType(), this.ref.isNullable(), this.ref.hasDocValues(), this.ref.position(), this.ref.oid(), this.ref.isDropped(), this.ref.defaultExpression());
                simpleReference.writeTo(out);
            }
        }
        out.writeString(this.formattedGeneratedExpression);
        if (version.onOrAfter(Version.V_5_1_0) && version.onOrBefore(Version.V_5_6_0)) {
            Symbol.nullableToStream(this.generatedExpression, out);
        } else {
            Symbol.toStream(this.generatedExpression, out);
        }
        out.writeVInt(this.referencedReferences.size());
        for (Reference reference : this.referencedReferences) {
            Reference.toStream(out, reference);
        }
    }

    public Reference reference() {
        return this.ref;
    }

    public String formattedGeneratedExpression() {
        return this.formattedGeneratedExpression;
    }

    public Symbol generatedExpression() {
        return this.generatedExpression;
    }

    public List<Reference> referencedReferences() {
        return this.referencedReferences;
    }

    @Override
    public boolean isDeterministic() {
        return this.generatedExpression.isDeterministic();
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.GENERATED_REFERENCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof GeneratedReference)) return false;
        GeneratedReference that = (GeneratedReference)o;
        if (!this.generatedExpression.equals(that.generatedExpression)) return false;
        if (!this.referencedReferences.equals(that.referencedReferences)) return false;
        if (!this.ref.equals(that.ref)) return false;
        return true;
    }

    public int hashCode() {
        int result = this.generatedExpression.hashCode();
        result = 31 * result + this.ref.hashCode();
        result = 31 * this.referencedReferences.hashCode();
        return result;
    }

    public String toString() {
        return this.column().quotedOutputName() + " AS " + this.formattedGeneratedExpression;
    }

    @Override
    public String toString(Style style) {
        return this.column().quotedOutputName();
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitReference(this, context);
    }

    @Override
    public ReferenceIdent ident() {
        return this.ref.ident();
    }

    @Override
    public ColumnIdent column() {
        return this.ref.column();
    }

    @Override
    public IndexType indexType() {
        return this.ref.indexType();
    }

    @Override
    public boolean isNullable() {
        return this.ref.isNullable();
    }

    @Override
    public RowGranularity granularity() {
        return this.ref.granularity();
    }

    @Override
    public int position() {
        return this.ref.position();
    }

    @Override
    public long oid() {
        return this.ref.oid();
    }

    @Override
    public boolean isDropped() {
        return this.ref.isDropped();
    }

    @Override
    public boolean hasDocValues() {
        return this.ref.hasDocValues();
    }

    @Override
    public DataType<?> valueType() {
        return this.ref.valueType();
    }

    @Override
    public Symbol cast(DataType<?> targetType, CastMode ... modes) {
        Symbol result = Reference.super.cast(targetType, modes);
        if (result == this) {
            return this;
        }
        if (result instanceof Reference) {
            Reference castRef = (Reference)result;
            if (!(result instanceof GeneratedReference)) {
                return new GeneratedReference(castRef, this.formattedGeneratedExpression, this.generatedExpression);
            }
        }
        return result;
    }

    @Override
    public Symbol defaultExpression() {
        return this.ref.defaultExpression();
    }

    @Override
    public boolean isGenerated() {
        return true;
    }

    @Override
    public Reference withReferenceIdent(ReferenceIdent referenceIdent) {
        return new GeneratedReference(this.ref.withReferenceIdent(referenceIdent), this.formattedGeneratedExpression, this.generatedExpression);
    }

    @Override
    public Reference withOidAndPosition(LongSupplier acquireOid, IntSupplier acquirePosition) {
        Reference newRef = this.ref.withOidAndPosition(acquireOid, acquirePosition);
        if (newRef == this.ref) {
            return this;
        }
        return new GeneratedReference(newRef, this.formattedGeneratedExpression, this.generatedExpression);
    }

    @Override
    public Reference withDropped(boolean dropped) {
        return new GeneratedReference(this.ref.withDropped(dropped), this.formattedGeneratedExpression, this.generatedExpression);
    }

    @Override
    public Reference withValueType(DataType<?> type) {
        return new GeneratedReference(this.ref.withValueType(type), this.formattedGeneratedExpression, this.generatedExpression.cast(type, new CastMode[0]));
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.ref.ramBytesUsed() + RamUsageEstimator.sizeOf((String)this.formattedGeneratedExpression) + (this.generatedExpression == null ? 0L : this.generatedExpression.ramBytesUsed()) + this.referencedReferences.stream().mapToLong(Accountable::ramBytesUsed).sum();
    }

    @Override
    public Map<String, Object> toMapping(int position) {
        return this.ref.toMapping(position);
    }
}

