/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.SimpleReference;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexReference
extends SimpleReference {
    @Nullable
    private final String analyzer;
    @NotNull
    private final List<Reference> columns;

    public IndexReference(StreamInput in) throws IOException {
        super(in);
        this.analyzer = in.readOptionalString();
        int size = in.readVInt();
        this.columns = new ArrayList<Reference>(size);
        for (int i = 0; i < size; ++i) {
            this.columns.add((Reference)Reference.fromStream(in));
        }
    }

    public IndexReference(int position, long oid, boolean isDropped, ReferenceIdent ident, IndexType indexType, List<Reference> columns, @Nullable String analyzer) {
        super(ident, RowGranularity.DOC, DataTypes.STRING, indexType, false, false, position, oid, isDropped, null);
        this.columns = columns;
        this.analyzer = analyzer;
    }

    public IndexReference(ReferenceIdent ident, RowGranularity granularity, DataType<?> type, IndexType indexType, boolean nullable, boolean hasDocValues, int position, long oid, boolean isDropped, Symbol defaultExpression, List<Reference> columns, String analyzer) {
        super(ident, granularity, type, indexType, nullable, hasDocValues, position, oid, isDropped, defaultExpression);
        this.columns = columns;
        this.analyzer = analyzer;
    }

    public List<Reference> columns() {
        return this.columns;
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.INDEX_REFERENCE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexReference that = (IndexReference)o;
        return Objects.equals(this.analyzer, that.analyzer) && Objects.equals(this.columns, that.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.analyzer, this.columns);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.analyzer);
        out.writeVInt(this.columns.size());
        for (Reference reference : this.columns) {
            Reference.toStream(out, reference);
        }
    }

    @Override
    public Reference withReferenceIdent(ReferenceIdent newIdent) {
        return new IndexReference(newIdent, this.granularity, this.type, this.indexType, this.nullable, this.hasDocValues, this.position, this.oid, this.isDropped, this.defaultExpression, this.columns, this.analyzer);
    }

    @Override
    public Reference withOidAndPosition(LongSupplier acquireOid, IntSupplier acquirePosition) {
        int newPosition;
        long newOid = this.oid == Metadata.COLUMN_OID_UNASSIGNED ? acquireOid.getAsLong() : this.oid;
        int n = newPosition = this.position < 0 ? acquirePosition.getAsInt() : this.position;
        if (newOid == this.oid && newPosition == this.position) {
            return this;
        }
        return new IndexReference(this.ident, this.granularity, this.type, this.indexType, this.nullable, this.hasDocValues, newPosition, newOid, this.isDropped, this.defaultExpression, this.columns, this.analyzer);
    }

    @Override
    public Reference withDropped(boolean dropped) {
        return new IndexReference(this.ident, this.granularity, this.type, this.indexType, this.nullable, this.hasDocValues, this.position, this.oid, dropped, this.defaultExpression, this.columns, this.analyzer);
    }

    @Override
    public IndexReference withValueType(DataType<?> newType) {
        return new IndexReference(this.ident, this.granularity, newType, this.indexType, this.nullable, this.hasDocValues, this.position, this.oid, this.isDropped, this.defaultExpression, this.columns, this.analyzer);
    }

    @Override
    public Map<String, Object> toMapping(int position) {
        Map<String, Object> mapping = super.toMapping(position);
        if (this.analyzer != null) {
            mapping.put("analyzer", this.analyzer);
        }
        mapping.put("type", "text");
        if (!this.columns.isEmpty()) {
            mapping.put("sources", this.columns.stream().map(Reference::storageIdent).toList());
        }
        return mapping;
    }

    public IndexReference updateColumns(List<Reference> newColumns) {
        return new IndexReference(this.ident, this.granularity, this.type, this.indexType, this.nullable, this.hasDocValues, this.position, this.oid, this.isDropped, this.defaultExpression, newColumns, this.analyzer);
    }

    public static class Builder {
        private final ReferenceIdent ident;
        private IndexType indexType = IndexType.FULLTEXT;
        @Deprecated
        private List<Reference> columns = new ArrayList<Reference>();
        private String analyzer = null;
        private int position = 0;
        private long oid;
        private boolean isDropped;
        private List<String> sourceNames = new ArrayList<String>();

        public Builder(ReferenceIdent ident) {
            Objects.requireNonNull(ident, "ident is null");
            this.ident = ident;
        }

        public Builder indexType(IndexType indexType) {
            this.indexType = indexType;
            return this;
        }

        @Deprecated
        public Builder addColumn(Reference info) {
            this.columns.add(info);
            return this;
        }

        public Builder sources(List<String> sourceNames) {
            this.sourceNames = sourceNames;
            return this;
        }

        public Builder analyzer(String name) {
            this.analyzer = name;
            return this;
        }

        public Builder position(int position) {
            this.position = position;
            return this;
        }

        public Builder oid(long oid) {
            this.oid = oid;
            return this;
        }

        public Builder setDropped(boolean isDropped) {
            this.isDropped = isDropped;
            return this;
        }

        public IndexReference build(Map<ColumnIdent, Reference> references) {
            assert (this.columns.isEmpty() ^ this.sourceNames.isEmpty()) : "Only one of columns/sourceNames can be set.";
            if (!this.columns.isEmpty()) {
                return new IndexReference(this.position, this.oid, this.isDropped, this.ident, this.indexType, this.columns, this.analyzer);
            }
            ArrayList<Reference> sources = new ArrayList<Reference>(this.sourceNames.size());
            for (String sourceName : this.sourceNames) {
                Reference ref = references.values().stream().filter(r -> r.storageIdent().equals(sourceName)).findAny().orElseThrow();
                sources.add(ref);
            }
            return new IndexReference(this.position, this.oid, this.isDropped, this.ident, this.indexType, sources, this.analyzer);
        }
    }
}

