/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.expression.NestableInput;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import java.util.Map;

public final class MapBackedRefResolver
implements ReferenceResolver<NestableInput<?>> {
    private Map<ColumnIdent, NestableInput<?>> implByColumn;

    public MapBackedRefResolver(Map<ColumnIdent, NestableInput<?>> implByColumn) {
        this.implByColumn = implByColumn;
    }

    @Override
    public NestableInput<?> getImplementation(Reference ref) {
        return MapBackedRefResolver.lookupMapWithChildTraversal(this.implByColumn, ref.column());
    }

    static NestableInput<?> lookupMapWithChildTraversal(Map<ColumnIdent, NestableInput<?>> implByColumn, ColumnIdent column) {
        if (column.isRoot()) {
            return implByColumn.get(column);
        }
        NestableInput<?> rootImpl = implByColumn.get(column.getRoot());
        if (rootImpl == null) {
            return implByColumn.get(column);
        }
        return NestableInput.getChildByPath(rootImpl, column.path());
    }
}

