/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import io.crate.exceptions.UnavailableShardsException;
import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.jetbrains.annotations.Nullable;

public final class RoutingProvider {
    private final int seed;
    private final List<String> awarenessAttributes;

    public RoutingProvider(int randomSeed, List<String> awarenessAttributes) {
        this.awarenessAttributes = awarenessAttributes;
        this.seed = randomSeed;
    }

    public Routing forRandomMasterOrDataNode(RelationName relationName, DiscoveryNodes nodes) {
        DiscoveryNode localNode = nodes.getLocalNode();
        if (localNode.isMasterEligibleNode() || localNode.isDataNode()) {
            return Routing.forTableOnSingleNode(relationName, localNode.getId());
        }
        ImmutableOpenMap<String, DiscoveryNode> masterAndDataNodes = nodes.getMasterAndDataNodes();
        int randomIdx = Math.abs(this.seed % masterAndDataNodes.size());
        Iterator<DiscoveryNode> it = masterAndDataNodes.valuesIt();
        int currIdx = 0;
        while (it.hasNext()) {
            DiscoveryNode next = it.next();
            if (currIdx == randomIdx) {
                return Routing.forTableOnSingleNode(relationName, next.getId());
            }
            ++currIdx;
        }
        throw new AssertionError((Object)("Cannot find a master or data node with given random index " + randomIdx));
    }

    public ShardRouting forId(ClusterState state, String index, String id, @Nullable String routing) {
        IndexMetadata indexMetadata = OperationRouting.indexMetadata(state, index);
        ShardId shardId = new ShardId(indexMetadata.getIndex(), OperationRouting.generateShardId(indexMetadata, id, routing));
        IndexShardRoutingTable routingTable = state.routingTable().shardRoutingTable(shardId);
        ShardRouting shardRouting = this.awarenessAttributes.isEmpty() ? routingTable.activeInitializingShardsIt(this.seed).nextOrNull() : routingTable.preferAttributesActiveInitializingShardsIt(this.awarenessAttributes, state.nodes(), this.seed).nextOrNull();
        return shardRouting == null ? routingTable.primaryShard() : shardRouting;
    }

    public Routing forIndices(ClusterState state, String[] concreteIndices, Set<String> routingValues, boolean ignoreMissingShards, ShardSelection shardSelection) {
        Set<IndexShardRoutingTable> shards;
        try {
            shards = RoutingProvider.computeTargetedShards(state, concreteIndices, routingValues);
        }
        catch (IndexNotFoundException e) {
            return new Routing(Collections.emptyMap());
        }
        TreeMap<String, Map<String, IntIndexedContainer>> locations = new TreeMap<String, Map<String, IntIndexedContainer>>();
        for (IndexShardRoutingTable shard : shards) {
            RoutingProvider.fillLocationsFromShardIterator(ignoreMissingShards, locations, switch (shardSelection.ordinal()) {
                case 0 -> {
                    if (this.awarenessAttributes.isEmpty()) {
                        yield shard.activeInitializingShardsIt(this.seed);
                    }
                    yield shard.preferAttributesActiveInitializingShardsIt(this.awarenessAttributes, state.nodes(), this.seed);
                }
                case 1 -> shard.primaryShardIt();
                default -> throw new AssertionError((Object)("Invalid ShardSelection: " + String.valueOf((Object)shardSelection)));
            });
        }
        return new Routing(locations);
    }

    private static void fillLocationsFromShardIterator(boolean ignoreMissingShards, Map<String, Map<String, IntIndexedContainer>> locations, ShardIterator shardIterator) {
        ShardRouting shardRouting = shardIterator.nextOrNull();
        if (shardRouting == null) {
            if (ignoreMissingShards) {
                return;
            }
            throw new UnavailableShardsException(shardIterator.shardId());
        }
        RoutingProvider.processShardRouting(locations, shardRouting);
    }

    private static void processShardRouting(Map<String, Map<String, IntIndexedContainer>> locations, ShardRouting shardRouting) {
        String indexName;
        IntIndexedContainer shards;
        String node = shardRouting.currentNodeId();
        Map<String, IntIndexedContainer> nodeMap = locations.get(node);
        if (nodeMap == null) {
            nodeMap = new TreeMap<String, IntIndexedContainer>();
            locations.put(shardRouting.currentNodeId(), nodeMap);
        }
        if ((shards = nodeMap.get(indexName = shardRouting.getIndexName())) == null) {
            shards = new IntArrayList();
            nodeMap.put(indexName, shards);
        }
        shards.add(shardRouting.id());
    }

    private static Set<IndexShardRoutingTable> computeTargetedShards(ClusterState clusterState, String[] concreteIndices, Set<String> routingValues) {
        LinkedHashSet<IndexShardRoutingTable> set = new LinkedHashSet<IndexShardRoutingTable>();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRouting = RoutingProvider.indexRoutingTable(clusterState, index);
            IndexMetadata indexMetadata = OperationRouting.indexMetadata(clusterState, index);
            if (!routingValues.isEmpty()) {
                for (String r : routingValues) {
                    int routingPartitionSize = indexMetadata.getRoutingPartitionSize();
                    for (int partitionOffset = 0; partitionOffset < routingPartitionSize; ++partitionOffset) {
                        set.add(RoutingProvider.shardRoutingTable(indexRouting, OperationRouting.calculateScaledShardId(indexMetadata, r, partitionOffset)));
                    }
                }
                continue;
            }
            for (IndexShardRoutingTable indexShard : indexRouting) {
                set.add(indexShard);
            }
        }
        return set;
    }

    private static IndexRoutingTable indexRoutingTable(ClusterState clusterState, String index) {
        IndexRoutingTable indexRouting = clusterState.routingTable().index(index);
        if (indexRouting == null) {
            throw new IndexNotFoundException(index);
        }
        return indexRouting;
    }

    private static IndexShardRoutingTable shardRoutingTable(IndexRoutingTable indexRouting, int shardId) {
        IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
        if (indexShard == null) {
            throw new ShardNotFoundException(new ShardId(indexRouting.getIndex(), shardId));
        }
        return indexShard;
    }

    public static enum ShardSelection {
        ANY,
        PRIMARIES;

    }
}

