/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import io.crate.common.collections.Sets;
import io.crate.exceptions.OperationOnInaccessibleRelationException;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.SchemaUnknownException;
import io.crate.expression.udf.UserDefinedFunctionMetadata;
import io.crate.expression.udf.UserDefinedFunctionsMetadata;
import io.crate.fdw.ForeignTable;
import io.crate.fdw.ForeignTablesMetadata;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.SearchPath;
import io.crate.metadata.doc.DocSchemaInfoFactory;
import io.crate.metadata.pgcatalog.OidHash;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.metadata.view.View;
import io.crate.metadata.view.ViewInfo;
import io.crate.metadata.view.ViewMetadata;
import io.crate.metadata.view.ViewsMetadata;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.Securable;
import io.crate.sql.tree.QualifiedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class Schemas
extends AbstractLifecycleComponent
implements Iterable<SchemaInfo>,
ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(Schemas.class);
    public static final Collection<String> READ_ONLY_SYSTEM_SCHEMAS = Set.of("sys", "information_schema", "pg_catalog");
    private static final Pattern SCHEMA_PATTERN = Pattern.compile("^([^.]+)\\.(.+)");
    public static final String DOC_SCHEMA_NAME = "doc";
    private final ClusterService clusterService;
    private final DocSchemaInfoFactory docSchemaInfoFactory;
    private final Roles roles;
    private final Map<String, SchemaInfo> schemas = new ConcurrentHashMap<String, SchemaInfo>();
    private final Map<String, SchemaInfo> builtInSchemas;

    public Schemas(Map<String, SchemaInfo> builtInSchemas, ClusterService clusterService, DocSchemaInfoFactory docSchemaInfoFactory, Roles roles) {
        this.clusterService = clusterService;
        this.docSchemaInfoFactory = docSchemaInfoFactory;
        this.roles = roles;
        this.schemas.putAll(builtInSchemas);
        this.builtInSchemas = builtInSchemas;
    }

    private List<String> getSimilarTables(Role user, String tableName, Iterable<TableInfo> tables) {
        LevenshteinDistance levenshteinDistance = new LevenshteinDistance();
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (TableInfo table : tables) {
            if (!this.roles.hasAnyPrivilege(user, Securable.TABLE, table.ident().fqn())) continue;
            String candidate = table.ident().name();
            float score = levenshteinDistance.getDistance(tableName.toLowerCase(Locale.ENGLISH), candidate.toLowerCase(Locale.ENGLISH));
            if (!(score > 0.7f)) continue;
            candidates.add(new Candidate(score, candidate));
        }
        candidates.sort(Comparator.comparing(x -> x.score).reversed());
        return candidates.stream().limit(5L).map(x -> x.name).toList();
    }

    private List<String> getSimilarSchemas(Role user, String schema) {
        LevenshteinDistance levenshteinDistance = new LevenshteinDistance();
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (String availableSchema : this.schemas.keySet()) {
            float score;
            if (!this.roles.hasAnyPrivilege(user, Securable.SCHEMA, availableSchema) || !((score = levenshteinDistance.getDistance(schema.toLowerCase(Locale.ENGLISH), availableSchema.toLowerCase(Locale.ENGLISH))) > 0.7f)) continue;
            candidates.add(new Candidate(score, availableSchema));
        }
        candidates.sort(Comparator.comparing(x -> x.score).reversed());
        return candidates.stream().limit(5L).map(x -> x.name).toList();
    }

    public <T extends RelationInfo> T findRelation(QualifiedName qName, Operation operation, Role user, SearchPath searchPath) {
        String schemaName = Schemas.schemaName(qName);
        String tableName = Schemas.relationName(qName);
        RelationInfo relationInfo = null;
        if (schemaName == null) {
            SchemaInfo schemaInfo;
            String schema;
            Iterator<String> iterator = searchPath.iterator();
            while (iterator.hasNext() && (relationInfo = this.getForeignTable(schema = iterator.next(), tableName)) == null && ((schemaInfo = this.schemas.get(schema)) == null || (relationInfo = schemaInfo.getTableInfo(tableName)) == null && (relationInfo = schemaInfo.getViewInfo(tableName)) == null)) {
            }
            if (relationInfo == null) {
                SchemaInfo currentSchema = this.schemas.get(searchPath.currentSchema());
                if (currentSchema == null) {
                    throw new RelationUnknown(tableName);
                }
                throw RelationUnknown.of(tableName, this.getSimilarTables(user, tableName, currentSchema.getTables()));
            }
        } else {
            if (relationInfo == null) {
                relationInfo = this.getForeignTable(schemaName, tableName);
            }
            if (relationInfo == null) {
                SchemaInfo schemaInfo = this.schemas.get(schemaName);
                if (schemaInfo == null) {
                    throw SchemaUnknownException.of(schemaName, this.getSimilarSchemas(user, schemaName));
                }
                relationInfo = schemaInfo.getTableInfo(tableName);
                if (relationInfo == null && (relationInfo = schemaInfo.getViewInfo(tableName)) == null) {
                    throw RelationUnknown.of(schemaName + "." + tableName, this.getSimilarTables(user, tableName, schemaInfo.getTables()));
                }
            }
        }
        Operation.blockedRaiseException(relationInfo, operation);
        try {
            return (T)relationInfo;
        }
        catch (ClassCastException e) {
            throw new OperationOnInaccessibleRelationException(relationInfo.ident(), "The relation " + relationInfo.ident().sqlFqn() + " doesn't support " + String.valueOf((Object)operation) + " operations");
        }
    }

    @Nullable
    private static String schemaName(QualifiedName ident) {
        assert (ident.getParts().size() <= 3) : "When identifying schemas or tables a qualified name should not have more the 3 parts";
        List parts = ident.getParts();
        if (parts.size() >= 2) {
            return (String)parts.get(parts.size() - 2);
        }
        return null;
    }

    private static String relationName(QualifiedName ident) {
        assert (ident.getParts().size() <= 3) : "When identifying schemas or tables a qualified name should not have more the 3 parts";
        List parts = ident.getParts();
        return (String)parts.get(parts.size() - 1);
    }

    public <T extends TableInfo> T getTableInfo(RelationName ident) {
        Metadata metadata;
        ForeignTablesMetadata foreignTables;
        SchemaInfo schemaInfo = this.getSchemaInfo(ident);
        TableInfo info = schemaInfo.getTableInfo(ident.name());
        if (info == null && (info = (foreignTables = (metadata = this.clusterService.state().metadata()).custom("foreign_tables", ForeignTablesMetadata.EMPTY)).get(ident)) == null) {
            throw new RelationUnknown(ident);
        }
        try {
            return (T)info;
        }
        catch (ClassCastException e) {
            throw new OperationOnInaccessibleRelationException(info.ident(), "The relation " + info.ident().sqlFqn() + " doesn't support the operation");
        }
    }

    private SchemaInfo getSchemaInfo(RelationName ident) {
        String schemaName = ident.schema();
        SchemaInfo schemaInfo = this.schemas.get(schemaName);
        if (schemaInfo == null) {
            throw new SchemaUnknownException(schemaName);
        }
        return schemaInfo;
    }

    public SchemaInfo getSystemSchema(String name) {
        SchemaInfo schemaInfo = this.builtInSchemas.get(name);
        if (schemaInfo == null) {
            throw new SchemaUnknownException(name);
        }
        return schemaInfo;
    }

    @Override
    @NotNull
    public Iterator<SchemaInfo> iterator() {
        return this.schemas.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.metadataChanged()) {
            return;
        }
        Set<String> newCurrentSchemas = Schemas.getNewCurrentSchemas(event.state().metadata());
        Map<String, SchemaInfo> map = this.schemas;
        synchronized (map) {
            Set nonBuiltInSchemas = Sets.difference(this.schemas.keySet(), this.builtInSchemas.keySet());
            Set deleted = Sets.difference((Set)nonBuiltInSchemas, newCurrentSchemas);
            Set added = Sets.difference(newCurrentSchemas, this.schemas.keySet());
            for (String deletedSchema : deleted) {
                try {
                    this.schemas.remove(deletedSchema).close();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            for (String addedSchema : added) {
                this.schemas.put(addedSchema, this.getCustomSchemaInfo(addedSchema));
            }
            for (SchemaInfo schemaInfo : this) {
                schemaInfo.update(event);
            }
        }
    }

    @VisibleForTesting
    static Set<String> getNewCurrentSchemas(Metadata metadata) {
        ViewsMetadata viewsMetadata;
        HashSet<String> schemas = new HashSet<String>();
        schemas.add(DOC_SCHEMA_NAME);
        for (String index : metadata.getConcreteAllIndices()) {
            Schemas.addIfSchema(schemas, index);
        }
        for (ObjectCursor cursor : metadata.templates().keys()) {
            Schemas.addIfSchema(schemas, (String)cursor.value);
        }
        UserDefinedFunctionsMetadata udfMetadata = (UserDefinedFunctionsMetadata)metadata.custom("user_defined_functions");
        if (udfMetadata != null) {
            udfMetadata.functionsMetadata().stream().map(UserDefinedFunctionMetadata::schema).forEach(schemas::add);
        }
        if ((viewsMetadata = (ViewsMetadata)metadata.custom("views")) != null) {
            StreamSupport.stream(viewsMetadata.names().spliterator(), false).map(IndexName::decode).map(IndexParts::schema).forEach(schemas::add);
        }
        return schemas;
    }

    private static void addIfSchema(Set<String> schemas, String indexOrTemplate) {
        Matcher matcher = SCHEMA_PATTERN.matcher(indexOrTemplate);
        if (matcher.matches()) {
            schemas.add(matcher.group(1));
        }
    }

    private SchemaInfo getCustomSchemaInfo(String name) {
        return this.docSchemaInfoFactory.create(name, this.clusterService);
    }

    public static boolean isDefaultOrCustomSchema(@Nullable String schemaName) {
        if (schemaName == null) {
            return true;
        }
        return !schemaName.equals("information_schema") && !schemaName.equals("sys") && !schemaName.equals("blob") && !schemaName.equals("pg_catalog");
    }

    public boolean tableExists(RelationName relationName) {
        SchemaInfo schemaInfo = this.schemas.get(relationName.schema());
        if (schemaInfo == null) {
            return false;
        }
        TableInfo tableInfo = schemaInfo.getTableInfo(relationName.name());
        return tableInfo != null;
    }

    @Override
    protected void doStart() {
        this.clusterService.addListener(this);
    }

    @Override
    protected void doStop() {
        this.clusterService.removeListener(this);
    }

    @Override
    protected void doClose() {
    }

    @Nullable
    private ForeignTable getForeignTable(String schemaName, String tableName) {
        Metadata metadata = this.clusterService.state().metadata();
        ForeignTablesMetadata foreignTables = (ForeignTablesMetadata)metadata.custom("foreign_tables");
        if (foreignTables == null) {
            return null;
        }
        return foreignTables.get(new RelationName(schemaName, tableName));
    }

    public View findView(QualifiedName ident, SearchPath searchPath) {
        ViewsMetadata views = (ViewsMetadata)this.clusterService.state().metadata().custom("views");
        ViewMetadata metadata = null;
        RelationName name = null;
        String identSchema = Schemas.schemaName(ident);
        String viewName = Schemas.relationName(ident);
        if (views != null) {
            if (identSchema == null) {
                String pathSchema;
                SchemaInfo schemaInfo;
                Iterator<String> iterator = searchPath.iterator();
                while (iterator.hasNext() && ((schemaInfo = this.schemas.get(pathSchema = iterator.next())) == null || (metadata = views.getView(name = new RelationName(pathSchema, viewName))) == null)) {
                }
            } else {
                name = new RelationName(identSchema, viewName);
                metadata = views.getView(name);
            }
        }
        if (metadata == null) {
            throw new RelationUnknown(viewName);
        }
        return new View(name, metadata);
    }

    public boolean viewExists(RelationName relationName) {
        ViewsMetadata views = (ViewsMetadata)this.clusterService.state().metadata().custom("views");
        return views != null && views.getView(relationName) != null;
    }

    @Nullable
    public RelationName getRelation(int oid) {
        for (SchemaInfo schema : this) {
            for (RelationInfo relationInfo : schema.getTables()) {
                if (oid != OidHash.relationOid(relationInfo)) continue;
                return relationInfo.ident();
            }
            for (ViewInfo viewInfo : schema.getViews()) {
                if (oid != OidHash.relationOid(viewInfo)) continue;
                return viewInfo.ident();
            }
        }
        Metadata metadata = this.clusterService.state().metadata();
        ForeignTablesMetadata foreignTables = metadata.custom("foreign_tables", ForeignTablesMetadata.EMPTY);
        for (ForeignTable foreignTable : foreignTables) {
            if (oid != OidHash.relationOid(foreignTable)) continue;
            return foreignTable.ident();
        }
        return null;
    }

    static class Candidate {
        final double score;
        final String name;

        Candidate(double score, String name) {
            this.score = score;
            this.name = name;
        }
    }
}

