/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.common.collections.MapBuilder;
import io.crate.common.collections.Maps;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.server.xcontent.XContentHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.metadata.ColumnPositionResolver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.mapper.ContentPath;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class DDLClusterStateHelpers {
    public static IndexTemplateMetadata updateTemplate(IndexTemplateMetadata indexTemplateMetadata, Map<String, Object> newMappings, Map<String, Object> mappingsToRemove, Settings newSettings, IndexScopedSettings indexScopedSettings) {
        Map mapping = DDLClusterStateHelpers.removeFromMapping(DDLClusterStateHelpers.mergeTemplateMapping(indexTemplateMetadata, newMappings), mappingsToRemove);
        Settings settings = indexTemplateMetadata.settings();
        if (!newSettings.isEmpty()) {
            Settings mergedSettings = Settings.builder().put(indexTemplateMetadata.settings()).put(newSettings).build().filter(k -> !indexScopedSettings.isPrivateSetting((String)k));
            indexScopedSettings.validate(mergedSettings, true);
            settings = mergedSettings;
        }
        if (mapping.size() != 1 || !mapping.containsKey("default")) {
            mapping = MapBuilder.newMapBuilder().put((Object)"default", mapping).map();
        }
        try {
            return new IndexTemplateMetadata.Builder(indexTemplateMetadata).settings(settings).putMapping(Strings.toString(JsonXContent.builder().map(mapping))).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Set<IndexMetadata> indexMetadataSetFromIndexNames(Metadata metadata, String[] indices, IndexMetadata.State state) {
        HashSet<IndexMetadata> indicesMetadata = new HashSet<IndexMetadata>();
        for (String indexName : indices) {
            IndexMetadata indexMetadata = metadata.index(indexName);
            if (indexMetadata == null || indexMetadata.getState() == state) continue;
            indicesMetadata.add(indexMetadata);
        }
        return indicesMetadata;
    }

    @Nullable
    static IndexTemplateMetadata templateMetadata(Metadata metadata, RelationName relationName) {
        String templateName = PartitionName.templateName(relationName.schema(), relationName.name());
        return metadata.templates().get(templateName);
    }

    public static Map<String, Object> removeFromMapping(Map<String, Object> mapping, Map<String, Object> mappingsToRemove) {
        for (String key : mappingsToRemove.keySet()) {
            if (!mapping.containsKey(key)) continue;
            if (mapping.get(key) instanceof Map) {
                Object mapOrPropertyToRemove = mappingsToRemove.get(key);
                if (mapOrPropertyToRemove == null) {
                    mapping.remove(key);
                    continue;
                }
                mapping.put(key, DDLClusterStateHelpers.removeFromMapping((Map)mapping.get(key), (Map)mappingsToRemove.get(key)));
                continue;
            }
            mapping.remove(key);
        }
        return mapping;
    }

    @VisibleForTesting
    static Map<String, Object> mergeTemplateMapping(IndexTemplateMetadata templateMetadata, Map<String, Object> newMapping) {
        HashMap<String, Object> mergedMapping = new HashMap<String, Object>();
        Map<String, Object> mapping = DDLClusterStateHelpers.parseMapping(templateMetadata.mapping().toString());
        Object o = mapping.get("default");
        assert (o instanceof Map) : "o must not be null and must be instance of Map";
        XContentHelper.update(mergedMapping, (Map)o, false);
        XContentHelper.update(mergedMapping, newMapping, false);
        DDLClusterStateHelpers.populateColumnPositions(mergedMapping);
        return mergedMapping;
    }

    private static Map<String, Object> parseMapping(String mappingSource) {
        Map map;
        block8: {
            XContentParser parser = JsonXContent.JSON_XCONTENT.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, mappingSource);
            try {
                map = parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchException("failed to parse mapping", new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    public static boolean populateColumnPositions(Map<String, Object> mapping) {
        ColumnPositionResolver<Map<String, Object>> columnPositionResolver = new ColumnPositionResolver<Map<String, Object>>();
        int[] maxColumnPosition = new int[]{0};
        DDLClusterStateHelpers.populateColumnPositions(mapping, new ContentPath(), columnPositionResolver, maxColumnPosition);
        columnPositionResolver.updatePositions(maxColumnPosition[0]);
        return columnPositionResolver.numberOfColumnsToReposition() > 0;
    }

    private static void populateColumnPositions(Map<String, Object> mapping, ContentPath contentPath, ColumnPositionResolver<Map<String, Object>> columnPositionResolver, int[] maxColumnPosition) {
        Map properties = (Map)Maps.get(mapping, (String)"properties");
        if (properties == null) {
            return;
        }
        for (Map.Entry e : properties.entrySet()) {
            String name = (String)e.getKey();
            contentPath.add(name);
            Map columnProperties = (Map)e.getValue();
            columnProperties = (Map)Maps.getOrDefault((Map)columnProperties, (String)"inner", (Object)columnProperties);
            assert (columnProperties.containsKey("inner") || columnProperties.containsKey("position") && columnProperties.get("position") != null) : "Column position is missing: " + name;
            Integer position = (Integer)columnProperties.get("position");
            if (position != null) {
                if (position < 0) {
                    columnPositionResolver.addColumnToReposition(contentPath.pathAsText(""), position, columnProperties, (cp, p) -> cp.put("position", p), contentPath.currentDepth());
                } else {
                    maxColumnPosition[0] = Math.max(maxColumnPosition[0], position);
                }
            }
            DDLClusterStateHelpers.populateColumnPositions(columnProperties, contentPath, columnPositionResolver, maxColumnPosition);
            contentPath.remove();
        }
    }
}

