/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.execution.ddl.tables.DropTableRequest;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import java.util.Set;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.index.Index;

public class DropTableClusterStateTaskExecutor
extends DDLClusterStateTaskExecutor<DropTableRequest> {
    private final MetadataDeleteIndexService deleteIndexService;
    private final DDLClusterStateService ddlClusterStateService;

    public DropTableClusterStateTaskExecutor(MetadataDeleteIndexService deleteIndexService, DDLClusterStateService ddlClusterStateService) {
        this.deleteIndexService = deleteIndexService;
        this.ddlClusterStateService = ddlClusterStateService;
    }

    @Override
    protected ClusterState execute(ClusterState currentState, DropTableRequest request) throws Exception {
        RelationName relationName = request.tableIdent();
        Set<Index> concreteIndices = Set.of(IndexNameExpressionResolver.concreteIndices(currentState.metadata(), IndicesOptions.LENIENT_EXPAND_OPEN, relationName.indexNameOrAlias()));
        currentState = this.deleteIndexService.deleteIndices(currentState, concreteIndices);
        Metadata metadata = currentState.metadata();
        String templateName = PartitionName.templateName(relationName.schema(), relationName.name());
        if (metadata.templates().containsKey(templateName)) {
            currentState = ClusterState.builder(currentState).metadata(Metadata.builder(metadata).removeTemplate(templateName)).build();
        }
        currentState = this.ddlClusterStateService.onDropTable(currentState, request.tableIdent());
        return currentState;
    }
}

