/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.execution.ddl.tables.OpenTableRequest;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateHelpers;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexUpgradeService;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.IndicesService;

public class OpenTableClusterStateTaskExecutor
extends DDLClusterStateTaskExecutor<OpenTableRequest> {
    private final AllocationService allocationService;
    private final DDLClusterStateService ddlClusterStateService;
    private final MetadataIndexUpgradeService metadataIndexUpgradeService;
    private final IndicesService indicesService;

    public OpenTableClusterStateTaskExecutor(AllocationService allocationService, DDLClusterStateService ddlClusterStateService, MetadataIndexUpgradeService metadataIndexUpgradeService, IndicesService indexServices) {
        this.allocationService = allocationService;
        this.ddlClusterStateService = ddlClusterStateService;
        this.metadataIndexUpgradeService = metadataIndexUpgradeService;
        this.indicesService = indexServices;
    }

    @Override
    protected ClusterState execute(ClusterState currentState, OpenTableRequest request) throws Exception {
        Context context = this.prepare(currentState, request);
        Set<IndexMetadata> indicesToOpen = context.indicesMetadata();
        IndexTemplateMetadata templateMetadata = context.templateMetadata();
        if (indicesToOpen.isEmpty() && templateMetadata == null) {
            return currentState;
        }
        Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        Version minIndexCompatibilityVersion = currentState.nodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
        for (IndexMetadata closedMetadata : indicesToOpen) {
            String indexName = closedMetadata.getIndex().getName();
            blocksBuilder.removeIndexBlockWithId(indexName, 4);
            if (closedMetadata.getState() == IndexMetadata.State.OPEN) continue;
            Settings.Builder updatedSettings = Settings.builder().put(closedMetadata.getSettings());
            updatedSettings.remove(IndexMetadata.VERIFIED_BEFORE_CLOSE_SETTING.getKey());
            IndexMetadata updatedIndexMetadata = IndexMetadata.builder(closedMetadata).state(IndexMetadata.State.OPEN).settingsVersion(closedMetadata.getSettingsVersion() + 1L).settings(updatedSettings).build();
            updatedIndexMetadata = this.metadataIndexUpgradeService.upgradeIndexMetadata(updatedIndexMetadata, templateMetadata, minIndexCompatibilityVersion, null);
            try {
                this.indicesService.verifyIndexMetadata(updatedIndexMetadata, updatedIndexMetadata);
            }
            catch (Exception e) {
                throw new ElasticsearchException("Failed to verify index " + indexName, (Throwable)e, new Object[0]);
            }
            mdBuilder.put(updatedIndexMetadata, true);
        }
        if (templateMetadata != null) {
            mdBuilder.put(OpenTableClusterStateTaskExecutor.updateOpenCloseOnPartitionTemplate(templateMetadata));
        }
        ClusterState updatedState = ClusterState.builder(currentState).metadata(mdBuilder).blocks(blocksBuilder).build();
        updatedState = context.partitionName() != null ? this.ddlClusterStateService.onOpenTablePartition(updatedState, context.partitionName()) : this.ddlClusterStateService.onOpenTable(updatedState, request.relation());
        RoutingTable.Builder rtBuilder = RoutingTable.builder(updatedState.routingTable());
        for (IndexMetadata index : indicesToOpen) {
            rtBuilder.addAsFromCloseToOpen(updatedState.metadata().getIndexSafe(index.getIndex()));
        }
        return this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(rtBuilder.build()).build(), "indices opened " + String.valueOf(indicesToOpen));
    }

    private Context prepare(ClusterState currentState, OpenTableRequest request) {
        RelationName relationName = request.relation();
        List<String> partitionValues = request.partitionValues();
        PartitionName partitionName = partitionValues.isEmpty() ? null : new PartitionName(relationName, partitionValues);
        Metadata metadata = currentState.metadata();
        String[] concreteIndices = IndexNameExpressionResolver.concreteIndexNames(currentState.metadata(), IndicesOptions.LENIENT_EXPAND_OPEN, partitionName == null ? relationName.indexNameOrAlias() : partitionName.asIndexName());
        Set<IndexMetadata> indicesMetadata = DDLClusterStateHelpers.indexMetadataSetFromIndexNames(metadata, concreteIndices, IndexMetadata.State.OPEN);
        IndexTemplateMetadata indexTemplateMetadata = null;
        if (partitionName == null) {
            indexTemplateMetadata = DDLClusterStateHelpers.templateMetadata(metadata, relationName);
        }
        return new Context(indicesMetadata, indexTemplateMetadata, partitionName);
    }

    private static IndexTemplateMetadata updateOpenCloseOnPartitionTemplate(IndexTemplateMetadata indexTemplateMetadata) {
        Map<String, Object> metaMap = Collections.singletonMap("_meta", Collections.singletonMap("closed", true));
        return DDLClusterStateHelpers.updateTemplate(indexTemplateMetadata, Collections.emptyMap(), metaMap, Settings.EMPTY, IndexScopedSettings.DEFAULT_SCOPED_SETTINGS);
    }

    private record Context(Set<IndexMetadata> indicesMetadata, IndexTemplateMetadata templateMetadata, PartitionName partitionName) {
    }
}

