/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.execution.ddl.Templates;
import io.crate.execution.ddl.tables.RenameTableRequest;
import io.crate.metadata.IndexName;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateHelpers;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.view.ViewsMetadata;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndexTemplateMissingException;

public class RenameTableClusterStateExecutor {
    private static final IndicesOptions STRICT_INDICES_OPTIONS = IndicesOptions.fromOptions(false, false, false, false);
    private final Logger logger;
    private final DDLClusterStateService ddlClusterStateService;
    private final AllocationService allocationService;

    public RenameTableClusterStateExecutor(AllocationService allocationService, DDLClusterStateService ddlClusterStateService) {
        this.allocationService = allocationService;
        this.logger = LogManager.getLogger(this.getClass());
        this.ddlClusterStateService = ddlClusterStateService;
    }

    public ClusterState execute(ClusterState currentState, RenameTableRequest request) throws Exception {
        ClusterBlocks.Builder blocksBuilder;
        RoutingTable.Builder newRoutingTable;
        Metadata.Builder newMetadata;
        RelationName target;
        RelationName source;
        block9: {
            boolean tableExists;
            source = request.sourceName();
            target = request.targetName();
            boolean isPartitioned = request.isPartitioned();
            Metadata currentMetadata = currentState.metadata();
            newMetadata = Metadata.builder(currentMetadata);
            ViewsMetadata views = (ViewsMetadata)currentMetadata.custom("views");
            boolean isView = views != null && views.contains(source);
            boolean viewExists = views != null && views.contains(target);
            boolean bl = tableExists = currentMetadata.hasIndex(target.indexNameOrAlias()) || DDLClusterStateHelpers.templateMetadata(currentMetadata, target) != null;
            if (viewExists || tableExists) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot rename %s %s to %s, %s %s already exists", isView ? "view" : "table", source, target, viewExists ? "view" : "table", target));
            }
            if (isView) {
                ViewsMetadata updatedViewsMetadata = views.rename(source, target);
                newMetadata.putCustom("views", updatedViewsMetadata);
                return ClusterState.builder(currentState).metadata(newMetadata).build();
            }
            if (isPartitioned) {
                IndexTemplateMetadata indexTemplateMetadata = DDLClusterStateHelpers.templateMetadata(currentMetadata, source);
                if (indexTemplateMetadata == null) {
                    throw new IndexTemplateMissingException("Template for partitioned table is missing");
                }
                RenameTableClusterStateExecutor.renameTemplate(newMetadata, indexTemplateMetadata, target);
            }
            newRoutingTable = RoutingTable.builder(currentState.routingTable());
            blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
            this.logger.info("renaming table '{}' to '{}'", (Object)source.fqn(), (Object)target.fqn());
            try {
                Index[] sourceIndices;
                for (Index sourceIndex : sourceIndices = IndexNameExpressionResolver.concreteIndices(currentState.metadata(), STRICT_INDICES_OPTIONS, source.indexNameOrAlias())) {
                    IndexMetadata targetMd;
                    IndexMetadata sourceIndexMetadata = currentMetadata.getIndexSafe(sourceIndex);
                    String sourceIndexName = sourceIndex.getName();
                    newMetadata.remove(sourceIndexName);
                    newRoutingTable.remove(sourceIndexName);
                    blocksBuilder.removeIndexBlocks(sourceIndexName);
                    if (isPartitioned) {
                        PartitionName partitionName = PartitionName.fromIndexOrTemplate(sourceIndexName);
                        String targetIndexName = IndexName.encode(target, partitionName.ident());
                        targetMd = IndexMetadata.builder(sourceIndexMetadata).removeAllAliases().putAlias(new AliasMetadata(target.indexNameOrAlias())).index(targetIndexName).build();
                    } else {
                        targetMd = IndexMetadata.builder(sourceIndexMetadata).index(target.indexNameOrAlias()).build();
                    }
                    newMetadata.put(targetMd, true);
                    newRoutingTable.addAsFromCloseToOpen(targetMd);
                    blocksBuilder.addBlocks(targetMd);
                }
            }
            catch (IndexNotFoundException e) {
                if (isPartitioned) break block9;
                throw e;
            }
        }
        ClusterState clusterStateAfterRename = ClusterState.builder(currentState).metadata(newMetadata).routingTable(newRoutingTable.build()).blocks(blocksBuilder).build();
        return this.allocationService.reroute(this.ddlClusterStateService.onRenameTable(clusterStateAfterRename, source, target, request.isPartitioned()), "rename-table");
    }

    private static void renameTemplate(Metadata.Builder newMetadata, IndexTemplateMetadata sourceTemplateMetadata, RelationName target) {
        IndexTemplateMetadata.Builder updatedTemplate = Templates.withName(sourceTemplateMetadata, target);
        newMetadata.removeTemplate(sourceTemplateMetadata.name()).put(updatedTemplate);
    }
}

