/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.doc;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.analyze.DropColumn;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.WhereClause;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.expressions.TableReferenceResolver;
import io.crate.common.collections.Lists;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.exceptions.RelationUnknown;
import io.crate.execution.ddl.tables.MappingUtil;
import io.crate.expression.symbol.DynamicReference;
import io.crate.expression.symbol.RefReplacer;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.VoidReference;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionInfo;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.ReferenceTree;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.SimpleReference;
import io.crate.metadata.doc.SysColumns;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.settings.NumberOfReplicas;
import io.crate.metadata.sys.TableColumn;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.ShardedTable;
import io.crate.metadata.table.StoredTable;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.ExpressionFormatter;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.CheckConstraint;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.sql.tree.Expression;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocTableInfo
implements TableInfo,
ShardedTable,
StoredTable {
    public static final Version COLUMN_OID_VERSION = Version.V_5_5_0;
    public static final Setting<Long> TOTAL_COLUMNS_LIMIT = Setting.longSetting("index.mapping.total_fields.limit", 1000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> DEPTH_LIMIT_SETTING = Setting.longSetting("index.mapping.depth.limit", 20L, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private final List<Reference> topLevelColumns;
    private final Set<Reference> droppedColumns;
    private final List<GeneratedReference> generatedColumns;
    private final List<Reference> partitionedByColumns;
    private final List<Reference> defaultExpressionColumns;
    private final Collection<ColumnIdent> notNullColumns;
    private final Map<ColumnIdent, IndexReference> indexColumns;
    private final Map<ColumnIdent, Reference> allColumns;
    private final Map<String, String> leafNamesByOid;
    private final RelationName ident;
    @Nullable
    private final String pkConstraintName;
    private final List<ColumnIdent> primaryKeys;
    private final List<CheckConstraint<Symbol>> checkConstraints;
    private final ColumnIdent clusteredBy;
    private final List<ColumnIdent> partitionedBy;
    private final int numberOfShards;
    private final String numberOfReplicas;
    private final Settings tableParameters;
    private final TableColumn docColumn;
    private final Set<Operation> supportedOperations;
    private final boolean hasAutoGeneratedPrimaryKey;
    private final boolean isPartitioned;
    private final Version versionCreated;
    private final Version versionUpgraded;
    private final boolean closed;
    private final ColumnPolicy columnPolicy;
    private ReferenceTree refTree;
    private final long tableVersion;

    public DocTableInfo(RelationName ident, Map<ColumnIdent, Reference> references, Map<ColumnIdent, IndexReference> indexColumns, @Nullable String pkConstraintName, List<ColumnIdent> primaryKeys, List<CheckConstraint<Symbol>> checkConstraints, ColumnIdent clusteredBy, Settings tableParameters, List<ColumnIdent> partitionedBy, ColumnPolicy columnPolicy, Version versionCreated, @Nullable Version versionUpgraded, boolean closed, Set<Operation> supportedOperations, long tableVersion) {
        this.notNullColumns = references.values().stream().filter(r -> !r.column().isSystemColumn()).filter(r -> !primaryKeys.contains(r.column())).filter(r -> !r.isNullable()).sorted(Reference.CMP_BY_POSITION_THEN_NAME).map(Reference::column).toList();
        this.droppedColumns = references.values().stream().filter(Reference::isDropped).collect(Collectors.toSet());
        this.allColumns = references.entrySet().stream().filter(entry -> !((Reference)entry.getValue()).isDropped()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.topLevelColumns = this.allColumns.values().stream().filter(r -> !r.column().isSystemColumn()).filter(r -> r.column().isRoot()).sorted(Reference.CMP_BY_POSITION_THEN_NAME).toList();
        SysColumns.forTable(ident, this.allColumns::put);
        this.partitionedByColumns = Lists.map(partitionedBy, x -> {
            Reference ref = this.allColumns.get(x);
            assert (ref != null) : "Column in `partitionedBy` must be present in `references`";
            return ref;
        });
        this.generatedColumns = this.allColumns.values().stream().filter(r -> r instanceof GeneratedReference && !r.isDropped()).map(r -> (GeneratedReference)r).toList();
        this.indexColumns = indexColumns;
        this.leafNamesByOid = new HashMap<String, String>();
        Stream.concat(Stream.concat(this.allColumns.values().stream(), indexColumns.values().stream()), this.droppedColumns.stream()).filter(r -> r.oid() != Metadata.COLUMN_OID_UNASSIGNED).forEach(r -> this.leafNamesByOid.put(Long.toString(r.oid()), r.column().leafName()));
        this.ident = ident;
        this.pkConstraintName = pkConstraintName;
        boolean isClusteredBySysId = clusteredBy == null || clusteredBy.equals(SysColumns.ID.COLUMN);
        this.primaryKeys = primaryKeys.isEmpty() && isClusteredBySysId && partitionedBy.isEmpty() ? List.of(SysColumns.ID.COLUMN) : primaryKeys;
        this.hasAutoGeneratedPrimaryKey = isClusteredBySysId && this.primaryKeys.size() == 1 && this.primaryKeys.get(0).equals(SysColumns.ID.COLUMN) && partitionedBy.isEmpty();
        this.checkConstraints = checkConstraints;
        this.clusteredBy = clusteredBy;
        Integer maybeNumberOfShards = tableParameters.getAsInt("index.number_of_shards", null);
        if (maybeNumberOfShards == null) {
            throw new IllegalArgumentException("must specify numberOfShards for " + String.valueOf(ident));
        }
        this.numberOfShards = maybeNumberOfShards;
        this.numberOfReplicas = NumberOfReplicas.getVirtualValue(tableParameters);
        this.tableParameters = tableParameters;
        this.isPartitioned = !this.partitionedByColumns.isEmpty();
        this.partitionedBy = partitionedBy;
        this.columnPolicy = columnPolicy;
        assert (versionCreated.after(Version.V_EMPTY)) : "Table must have a versionCreated";
        this.versionCreated = versionCreated;
        this.versionUpgraded = versionUpgraded;
        this.closed = closed;
        this.supportedOperations = supportedOperations;
        this.docColumn = new TableColumn(SysColumns.DOC, this.allColumns);
        this.defaultExpressionColumns = this.allColumns.values().stream().filter(r -> r.defaultExpression() != null).toList();
        this.tableVersion = tableVersion;
    }

    public long tableVersion() {
        return this.tableVersion;
    }

    @Override
    @Nullable
    public Reference getReference(ColumnIdent columnIdent) {
        Reference reference = this.allColumns.get(columnIdent);
        if (reference == null) {
            return this.docColumn.getReference(this.ident(), columnIdent);
        }
        return reference;
    }

    @Nullable
    public Reference getReference(String storageIdent) {
        try {
            long oid = Long.parseLong(storageIdent);
            for (Reference reference : this.allColumns.values()) {
                if (reference.oid() != oid) continue;
                return reference;
            }
            for (IndexReference indexReference : this.indexColumns.values()) {
                if (indexReference.oid() != oid) continue;
                return indexReference;
            }
            return null;
        }
        catch (NumberFormatException ex) {
            return this.getReference(ColumnIdent.fromPath(storageIdent));
        }
    }

    public List<Reference> getChildReferences(Reference parent) {
        return this.referenceTree().getChildren(parent);
    }

    public List<Reference> getLeafReferences(Reference parent) {
        return this.referenceTree().findDescendants(parent);
    }

    public Reference findParentReferenceMatching(Reference child, Predicate<Reference> test) {
        return this.referenceTree().findFirstParentMatching(child, test);
    }

    public Predicate<Reference> isParentReferenceIgnored() {
        return ref -> this.findParentReferenceMatching((Reference)ref, r -> r.valueType().columnPolicy() == ColumnPolicy.IGNORED) != null;
    }

    public boolean isIgnoredOrImmediateChildOfIgnored(Reference ref) {
        DataType<?> dataType = ArrayType.unnest(ref.valueType());
        if (dataType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)dataType;
            return objectType.columnPolicy() == ColumnPolicy.IGNORED;
        }
        for (Reference parent : this.getParents(ref.column())) {
            if (parent == null) continue;
            return parent.valueType().columnPolicy() == ColumnPolicy.IGNORED;
        }
        return false;
    }

    private ReferenceTree referenceTree() {
        if (this.refTree == null) {
            this.refTree = ReferenceTree.of(this.allColumns.values());
        }
        return this.refTree;
    }

    public List<Reference> columns() {
        return this.topLevelColumns;
    }

    @Override
    public Collection<Reference> allColumns() {
        return this.allColumns.values();
    }

    public Set<Reference> droppedColumns() {
        return this.droppedColumns;
    }

    @Override
    public int maxPosition() {
        return Math.max(this.allColumns.values().stream().filter(ref -> !ref.column().isSystemColumn()).mapToInt(Reference::position).max().orElse(0), this.indexColumns.values().stream().mapToInt(SimpleReference::position).max().orElse(0));
    }

    public List<Reference> defaultExpressionColumns() {
        return this.defaultExpressionColumns;
    }

    public List<GeneratedReference> generatedColumns() {
        return this.generatedColumns;
    }

    @Override
    public RowGranularity rowGranularity() {
        return RowGranularity.DOC;
    }

    @Override
    public RelationName ident() {
        return this.ident;
    }

    @Override
    public Routing getRouting(ClusterState state, RoutingProvider routingProvider, WhereClause whereClause, RoutingProvider.ShardSelection shardSelection, CoordinatorSessionSettings sessionSettings) {
        String[] indices = whereClause.partitions().isEmpty() ? this.concreteOpenIndices(state.metadata()) : whereClause.partitions().toArray(new String[0]);
        return routingProvider.forIndices(state, indices, whereClause.routingValues(), this.isPartitioned, shardSelection);
    }

    @Override
    public String pkConstraintName() {
        return this.pkConstraintName;
    }

    @Override
    public List<ColumnIdent> primaryKey() {
        return this.primaryKeys;
    }

    @Override
    public List<CheckConstraint<Symbol>> checkConstraints() {
        return this.checkConstraints;
    }

    @Override
    public int numberOfShards() {
        return this.numberOfShards;
    }

    @Override
    public String numberOfReplicas() {
        return this.numberOfReplicas;
    }

    @Override
    public ColumnIdent clusteredBy() {
        return this.clusteredBy;
    }

    public boolean hasAutoGeneratedPrimaryKey() {
        return this.hasAutoGeneratedPrimaryKey;
    }

    @Override
    public String[] concreteIndices(Metadata metadata) {
        try {
            String[] indexNames = IndexNameExpressionResolver.concreteIndexNames(metadata, this.isPartitioned ? IndicesOptions.LENIENT_EXPAND_OPEN : IndicesOptions.STRICT_EXPAND_OPEN, this.ident.indexNameOrAlias());
            return (String[])Arrays.stream(indexNames).filter(s -> !s.startsWith(".resized.")).toArray(String[]::new);
        }
        catch (IndexNotFoundException e) {
            throw new RelationUnknown(this.ident.fqn(), e);
        }
    }

    public String[] concreteOpenIndices(Metadata metadata) {
        if (!this.isPartitioned) {
            IndexMetadata index = metadata.index(this.ident.indexNameOrAlias());
            if (index == null) {
                throw new RelationUnknown(this.ident);
            }
            String[] concreteIndices = this.concreteIndices(metadata);
            if (concreteIndices.length == 0) {
                throw new RelationUnknown(this.ident);
            }
            return concreteIndices;
        }
        String[] indexNames = IndexNameExpressionResolver.concreteIndexNames(metadata, IndicesOptions.fromOptions(true, true, true, false, IndicesOptions.STRICT_EXPAND_OPEN_FORBID_CLOSED), this.ident.indexNameOrAlias());
        return (String[])Arrays.stream(indexNames).filter(s -> !s.startsWith(".resized.")).toArray(String[]::new);
    }

    public List<Reference> partitionedByColumns() {
        return this.partitionedByColumns;
    }

    public List<ColumnIdent> partitionedBy() {
        return this.partitionedBy;
    }

    public List<PartitionName> getPartitionNames(Metadata metadata) {
        if (!this.isPartitioned) {
            throw new IllegalArgumentException("Relation " + String.valueOf(this.ident) + " isn't partitioned, cannot get partitions");
        }
        String[] concreteIndices = this.concreteIndices(metadata);
        ArrayList<PartitionName> partitions = new ArrayList<PartitionName>(concreteIndices.length);
        for (String indexName : concreteIndices) {
            partitions.add(PartitionName.fromIndexOrTemplate(indexName));
        }
        return partitions;
    }

    public List<PartitionInfo> getPartitions(Metadata metadata) {
        if (!this.isPartitioned) {
            return List.of();
        }
        Index[] indices = IndexNameExpressionResolver.concreteIndices(metadata, IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED, this.ident.indexNameOrAlias());
        ArrayList<PartitionInfo> result = new ArrayList<PartitionInfo>(indices.length);
        for (Index index : indices) {
            IndexMetadata indexMetadata = metadata.index(index);
            PartitionName partitionName = PartitionName.fromIndexOrTemplate(index.getName());
            List<String> values = partitionName.values();
            HashMap<String, Object> valuesMap = HashMap.newHashMap(values.size());
            assert (values.size() == this.partitionedBy.size()) : "Number of values in partitionIdent must match number of partitionedBy columns";
            for (int i = 0; i < values.size(); ++i) {
                String value = values.get(i);
                Reference reference = this.partitionedByColumns.get(i);
                valuesMap.put(reference.column().sqlFqn(), reference.valueType().implicitCast(value));
            }
            Settings settings = indexMetadata.getSettings();
            PartitionInfo partitionInfo = new PartitionInfo(partitionName, indexMetadata.getNumberOfShards(), NumberOfReplicas.getVirtualValue(settings), IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(settings), settings.getAsVersion("index.version.upgraded", null), indexMetadata.getState() == IndexMetadata.State.CLOSE, valuesMap, settings);
            result.add(partitionInfo);
        }
        return result;
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public IndexReference indexColumn(ColumnIdent ident) {
        return this.indexColumns.get(ident);
    }

    public Collection<IndexReference> indexColumns() {
        return this.indexColumns.values();
    }

    @Override
    public Iterator<Reference> iterator() {
        return this.allColumns.values().stream().sorted(Reference.CMP_BY_POSITION_THEN_NAME).iterator();
    }

    public ColumnPolicy columnPolicy() {
        return this.columnPolicy;
    }

    @Override
    @NotNull
    public Version versionCreated() {
        return this.versionCreated;
    }

    @Override
    @Nullable
    public Version versionUpgraded() {
        return this.versionUpgraded;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Settings parameters() {
        return this.tableParameters;
    }

    @Override
    public Set<Operation> supportedOperations() {
        return this.supportedOperations;
    }

    @Override
    public RelationInfo.RelationType relationType() {
        return RelationInfo.RelationType.BASE_TABLE;
    }

    @Nullable
    public String getAnalyzerForColumnIdent(ColumnIdent ident) {
        Reference reference = this.allColumns.get(ident);
        if (reference instanceof GeneratedReference) {
            GeneratedReference gen = (GeneratedReference)reference;
            reference = gen.reference();
        }
        if (reference instanceof IndexReference) {
            IndexReference indexRef = (IndexReference)reference;
            return indexRef.analyzer();
        }
        return null;
    }

    @Nullable
    public DynamicReference getDynamic(ColumnIdent ident, boolean forWrite, boolean errorOnUnknownObjectKey) {
        boolean parentIsIgnored = false;
        ColumnPolicy parentPolicy = this.columnPolicy();
        int position = 0;
        for (Reference parent : this.getParents(ident)) {
            if (parent == null) continue;
            parentPolicy = parent.valueType().columnPolicy();
            position = parent.position();
            break;
        }
        switch (parentPolicy) {
            case DYNAMIC: {
                if (forWrite) break;
                if (!errorOnUnknownObjectKey) {
                    return new VoidReference(new ReferenceIdent(this.ident(), ident), position);
                }
                return null;
            }
            case STRICT: {
                if (forWrite) {
                    throw new ColumnUnknownException(ident, this.ident());
                }
                return null;
            }
            case IGNORED: {
                parentIsIgnored = true;
                break;
            }
        }
        if (parentIsIgnored) {
            return new DynamicReference(new ReferenceIdent(this.ident(), ident), this.rowGranularity(), position);
        }
        return new DynamicReference(new ReferenceIdent(this.ident(), ident), this.rowGranularity(), position);
    }

    @NotNull
    public Reference resolveColumn(String targetColumnName, boolean forWrite, boolean errorOnUnknownObjectKey) throws ColumnUnknownException {
        ColumnIdent columnIdent = ColumnIdent.fromPath(targetColumnName);
        Reference reference = this.getReference(columnIdent);
        if (reference == null && (reference = this.getDynamic(columnIdent, forWrite, errorOnUnknownObjectKey)) == null) {
            throw new ColumnUnknownException(columnIdent, this.ident);
        }
        return reference;
    }

    public String toString() {
        return this.ident.fqn();
    }

    public Collection<ColumnIdent> notNullColumns() {
        return this.notNullColumns;
    }

    public UnaryOperator<String> lookupNameBySourceKey() {
        return oidOrName -> {
            String name = this.leafNamesByOid.get(oidOrName);
            if (name == null) {
                if (oidOrName.startsWith("_u_")) {
                    assert (oidOrName.length() >= "_u_".length() + 1) : "Column name must consist of at least one character";
                    return oidOrName.substring("_u_".length());
                }
                return oidOrName;
            }
            return name;
        };
    }

    private void validateDropColumns(List<DropColumn> dropColumns) {
        Set leftOverCols = this.columns().stream().map(Reference::column).collect(Collectors.toSet());
        for (int i = 0; i < dropColumns.size(); ++i) {
            Reference refToDrop = dropColumns.get(i).ref();
            ColumnIdent colToDrop = refToDrop.column();
            for (IndexReference indexReference : this.indexColumns()) {
                if (!indexReference.columns().contains(refToDrop)) continue;
                throw new UnsupportedOperationException("Dropping column: " + colToDrop.sqlFqn() + " which is part of INDEX: " + String.valueOf(indexReference) + " is not allowed");
            }
            for (GeneratedReference generatedReference : this.generatedColumns()) {
                if (!generatedReference.referencedReferences().contains(refToDrop)) continue;
                throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot drop column `%s`. It's used in generated column `%s`: %s", colToDrop.sqlFqn(), generatedReference.column().sqlFqn(), generatedReference.formattedGeneratedExpression()));
            }
            for (CheckConstraint checkConstraint : this.checkConstraints()) {
                HashSet columnsInConstraint = new HashSet();
                ((Symbol)checkConstraint.expression()).visit(Reference.class, r -> columnsInConstraint.add(r.column()));
                if (columnsInConstraint.size() > 1 && columnsInConstraint.contains(colToDrop)) {
                    throw new UnsupportedOperationException("Dropping column: " + colToDrop.sqlFqn() + " which is used in CHECK CONSTRAINT: " + checkConstraint.name() + " is not allowed");
                }
                boolean constraintColIsSubColOfColToDrop = false;
                for (ColumnIdent columnInConstraint : columnsInConstraint) {
                    if (!columnInConstraint.isChildOf(colToDrop)) continue;
                    constraintColIsSubColOfColToDrop = true;
                }
                if (!constraintColIsSubColOfColToDrop) continue;
                for (ColumnIdent columnInConstraint : columnsInConstraint) {
                    if (columnInConstraint.isChildOf(colToDrop) || columnInConstraint.path().equals(colToDrop.path())) continue;
                    throw new UnsupportedOperationException("Dropping column: " + colToDrop.sqlFqn() + " which is used in CHECK CONSTRAINT: " + checkConstraint.name() + " is not allowed");
                }
            }
            leftOverCols.remove(colToDrop);
        }
        if (leftOverCols.isEmpty()) {
            throw new UnsupportedOperationException("Dropping all columns of a table is not allowed");
        }
    }

    private void updateParentsInnerTypes(ColumnIdent column, @Nullable DataType<?> type, Map<ColumnIdent, Reference> newReferences) {
        ColumnIdent[] child = new ColumnIdent[]{column};
        DataType[] childType = new DataType[]{type};
        for (ColumnIdent parent : column.parents()) {
            Reference parentRef = newReferences.get(parent);
            if (parentRef == null) {
                throw new ColumnUnknownException(column, this.ident);
            }
            DataType<?> newParentType = ArrayType.updateLeaf(parentRef.valueType(), leaf -> childType[0] == null ? ((ObjectType)leaf).withoutChild(child[0].leafName()) : ((ObjectType)leaf).withChild(child[0].leafName(), childType[0]));
            Reference updatedParent = parentRef.withValueType(newParentType);
            newReferences.replace(parent, updatedParent);
            child[0] = updatedParent.column();
            childType[0] = updatedParent.valueType();
        }
    }

    public DocTableInfo dropConstraint(String constraint) {
        List<CheckConstraint<Symbol>> newConstraints = this.checkConstraints.stream().filter(x -> !x.name().equals(constraint)).toList();
        if (newConstraints.size() == this.checkConstraints.size()) {
            return this;
        }
        return new DocTableInfo(this.ident, this.allColumns, this.indexColumns, this.pkConstraintName, this.primaryKeys, newConstraints, this.clusteredBy, this.tableParameters, this.partitionedBy, this.columnPolicy, this.versionCreated, this.versionUpgraded, this.closed, this.supportedOperations, this.tableVersion);
    }

    public DocTableInfo dropColumns(List<DropColumn> columns) {
        this.validateDropColumns(columns);
        HashSet<Reference> toDrop = HashSet.newHashSet(columns.size());
        HashMap<ColumnIdent, Reference> newReferences = new HashMap<ColumnIdent, Reference>(this.allColumns);
        this.droppedColumns.forEach(ref -> newReferences.put(ref.column(), (Reference)ref));
        for (DropColumn column : columns) {
            ColumnIdent columnIdent = column.ref().column();
            Reference reference = this.allColumns.get(columnIdent);
            if (toDrop.contains(reference)) continue;
            if (reference == null || reference.isDropped()) {
                if (column.ifExists()) continue;
                throw new ColumnUnknownException(columnIdent, this.ident);
            }
            if (columns.stream().noneMatch(c -> column.ref().column().isChildOf(c.ref().column()))) {
                this.updateParentsInnerTypes(columnIdent, null, newReferences);
            }
            toDrop.add(reference.withDropped(true));
            newReferences.replace(columnIdent, reference.withDropped(true));
            for (Reference ref2 : this.allColumns.values()) {
                if (!ref2.column().isChildOf(columnIdent)) continue;
                toDrop.add(ref2);
                newReferences.remove(ref2.column());
            }
        }
        if (toDrop.isEmpty()) {
            return this;
        }
        UnaryOperator updateRef = symbol -> RefReplacer.replaceRefs(symbol, ref -> newReferences.getOrDefault(ref.column(), (Reference)ref));
        ArrayList<CheckConstraint<Symbol>> newCheckConstraints = new ArrayList<CheckConstraint<Symbol>>(this.checkConstraints.size());
        for (CheckConstraint<Symbol> constraint : this.checkConstraints) {
            boolean drop = false;
            for (Reference ref3 : toDrop) {
                drop = ((Symbol)constraint.expression()).hasColumn(ref3.column());
                if (!drop) continue;
                break;
            }
            if (drop) continue;
            newCheckConstraints.add(constraint.map((Function)updateRef));
        }
        return new DocTableInfo(this.ident, newReferences, this.indexColumns, this.pkConstraintName, this.primaryKeys, newCheckConstraints, this.clusteredBy, this.tableParameters, this.partitionedBy, this.columnPolicy, this.versionCreated, this.versionUpgraded, this.closed, this.supportedOperations, this.tableVersion);
    }

    private void validateRenameColumn(Reference refToRename, ColumnIdent newName) {
        ColumnIdent oldName = refToRename.column();
        Reference reference = this.getReference(oldName);
        if (reference == null) {
            reference = this.indexColumn(oldName);
        }
        if (!refToRename.equals(reference)) {
            throw new ColumnUnknownException(oldName, this.ident);
        }
        if (this.getReference(newName) != null || this.indexColumn(newName) != null) {
            throw new IllegalArgumentException("Cannot rename column to a name that is in use");
        }
    }

    public DocTableInfo renameColumn(Reference refToRename, ColumnIdent newName) {
        this.validateRenameColumn(refToRename, newName);
        ColumnIdent oldName = refToRename.column();
        Predicate<ColumnIdent> toBeRenamed = c -> c.equals(oldName) || c.isChildOf(oldName);
        HashMap<ColumnIdent, Reference> oldNameToRenamedRefs = new HashMap<ColumnIdent, Reference>();
        for (Reference ref2 : this.allColumns.values()) {
            ColumnIdent column2 = ref2.column();
            if (toBeRenamed.test(column2)) {
                Reference renamedRef = ref2.withReferenceIdent(new ReferenceIdent(this.ident, ref2.column().replacePrefix(newName)));
                oldNameToRenamedRefs.put(column2, renamedRef);
                continue;
            }
            oldNameToRenamedRefs.put(column2, ref2);
        }
        this.updateParentsInnerTypes(oldName, null, oldNameToRenamedRefs);
        this.updateParentsInnerTypes(newName, refToRename.valueType(), oldNameToRenamedRefs);
        UnaryOperator renameGeneratedRefs = ref -> {
            if (ref instanceof GeneratedReference) {
                GeneratedReference genRef = (GeneratedReference)ref;
                return new GeneratedReference(genRef.reference(), RefReplacer.replaceRefs(genRef.generatedExpression(), r -> oldNameToRenamedRefs.getOrDefault(r.column(), (Reference)r)));
            }
            return ref;
        };
        UnaryOperator renameIndexRefs = idxRef -> {
            IndexReference updatedRef = idxRef.updateColumns(Lists.map(idxRef.columns(), r -> oldNameToRenamedRefs.getOrDefault(r.column(), (Reference)r)));
            if (toBeRenamed.test(idxRef.column())) {
                return (IndexReference)updatedRef.withReferenceIdent(new ReferenceIdent(idxRef.ident().tableIdent(), idxRef.column().replacePrefix(newName)));
            }
            return updatedRef;
        };
        UnaryOperator renameCheckConstraints = check -> {
            Symbol renamed = RefReplacer.replaceRefs((Symbol)check.expression(), r -> oldNameToRenamedRefs.getOrDefault(r.column(), (Reference)r));
            return new CheckConstraint(check.name(), (Object)renamed, ExpressionFormatter.formatStandaloneExpression((Expression)SqlParser.createExpression((String)renamed.toString(Style.UNQUALIFIED))));
        };
        Map<ColumnIdent, Reference> renamedReferences = oldNameToRenamedRefs.values().stream().map(renameGeneratedRefs).collect(Collectors.toMap(Reference::column, ref -> ref));
        Map<ColumnIdent, IndexReference> renamedIndexColumns = this.indexColumns.values().stream().map(renameIndexRefs).collect(Collectors.toMap(Reference::column, ref -> ref));
        UnaryOperator renameColumnIfMatch = column -> toBeRenamed.test((ColumnIdent)column) ? column.replacePrefix(newName) : column;
        ColumnIdent renamedClusteredBy = (ColumnIdent)renameColumnIfMatch.apply(this.clusteredBy);
        List renamedPrimaryKeys = Lists.map(this.primaryKeys, (Function)renameColumnIfMatch);
        List renamedPartitionedBy = Lists.map(this.partitionedBy, (Function)renameColumnIfMatch);
        List renamedCheckConstraints = Lists.map(this.checkConstraints, (Function)renameCheckConstraints);
        return new DocTableInfo(this.ident, renamedReferences, renamedIndexColumns, this.pkConstraintName, renamedPrimaryKeys, renamedCheckConstraints, renamedClusteredBy, this.tableParameters, renamedPartitionedBy, this.columnPolicy, this.versionCreated, this.versionUpgraded, this.closed, this.supportedOperations, this.tableVersion);
    }

    public Metadata.Builder writeTo(Metadata metadata, Metadata.Builder metadataBuilder) throws IOException {
        List<Reference> allColumns = Stream.concat(Stream.concat(this.droppedColumns.stream(), this.indexColumns.values().stream()), this.allColumns.values().stream()).filter(ref -> !ref.column().isSystemColumn()).sorted(Reference.CMP_BY_POSITION_THEN_NAME).toList();
        IntArrayList pKeyIndices = new IntArrayList(this.primaryKeys.size());
        for (ColumnIdent columnIdent : this.primaryKeys) {
            int n = Reference.indexOf(allColumns, columnIdent);
            if (n < 0) continue;
            pKeyIndices.add(n);
        }
        LinkedHashMap<String, String> checkConstraintMap = LinkedHashMap.newLinkedHashMap(this.checkConstraints.size());
        for (CheckConstraint<Symbol> checkConstraint : this.checkConstraints) {
            checkConstraintMap.put(checkConstraint.name(), checkConstraint.expressionStr());
        }
        MappingUtil.AllocPosition allocPosition = MappingUtil.AllocPosition.forTable(this);
        Map<String, Object> map = Map.of("default", MappingUtil.createMapping(allocPosition, this.pkConstraintName, allColumns, pKeyIndices, checkConstraintMap, Lists.map(this.partitionedByColumns, Reference::column), this.columnPolicy, this.clusteredBy == SysColumns.ID.COLUMN ? null : this.clusteredBy));
        for (String indexName : this.concreteIndices(metadata)) {
            IndexMetadata indexMetadata = metadata.index(indexName);
            if (indexMetadata == null) {
                throw new UnsupportedOperationException("Cannot create index via DocTableInfo.writeTo");
            }
            long allowedTotalColumns = TOTAL_COLUMNS_LIMIT.get(indexMetadata.getSettings());
            if ((long)allColumns.size() > allowedTotalColumns) {
                throw new IllegalArgumentException("Limit of total columns [" + allowedTotalColumns + "] in table [" + String.valueOf(this.ident) + "] exceeded");
            }
            int indexNumberOfShards = this.numberOfShards;
            if (this.isPartitioned && IndexName.isPartitioned(indexName)) {
                indexNumberOfShards = indexMetadata.getNumberOfShards();
            }
            Settings settings = Settings.builder().put(indexMetadata.getSettings()).put(this.tableParameters.filter(s -> !indexMetadata.getSettings().hasValue((String)s))).build();
            long newSettingsVersion = indexMetadata.getSettingsVersion();
            if (!settings.equals(indexMetadata.getSettings())) {
                ++newSettingsVersion;
            }
            metadataBuilder.put(IndexMetadata.builder(indexMetadata).putMapping(new MappingMetadata(map)).settings(settings).numberOfShards(indexNumberOfShards).mappingVersion(indexMetadata.getMappingVersion() + 1L).settingsVersion(newSettingsVersion));
        }
        if (this.isPartitioned) {
            String templateName = PartitionName.templateName(this.ident.schema(), this.ident.name());
            IndexTemplateMetadata indexTemplateMetadata = metadata.templates().get(templateName);
            if (indexTemplateMetadata == null) {
                throw new UnsupportedOperationException("Cannot create template via DocTableInfo.writeTo");
            }
            Integer version = indexTemplateMetadata.version();
            Settings settings = Settings.builder().put(indexTemplateMetadata.settings()).put(this.tableParameters.filter(s -> !indexTemplateMetadata.settings().hasValue((String)s))).build();
            IndexTemplateMetadata template = new IndexTemplateMetadata.Builder(indexTemplateMetadata).putMapping(Strings.toString(JsonXContent.builder().map(map))).settings(settings).version(version == null ? 1 : version + 1).build();
            metadataBuilder.put(template);
        }
        return metadataBuilder;
    }

    private boolean addNewReferences(LongSupplier acquireOid, AtomicInteger positions, HashMap<ColumnIdent, Reference> newReferences, HashMap<ColumnIdent, List<Reference>> tree, @Nullable ColumnIdent node) {
        List<Reference> children = tree.get(node);
        if (children == null) {
            return false;
        }
        boolean addedColumn = false;
        for (Reference newRef : children) {
            ColumnIdent newColumn = newRef.column();
            Reference exists = this.getReference(newColumn);
            if (exists == null) {
                if (this.indexColumns.containsKey(newColumn)) {
                    throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Index column `%s` already exists", newColumn));
                }
                addedColumn = true;
                newReferences.put(newColumn, newRef.withOidAndPosition(acquireOid, positions::incrementAndGet));
            } else if (DataTypes.isArrayOfNulls(exists.valueType()) && newRef.valueType().id() == 100 && !DataTypes.isArrayOfNulls(newRef.valueType())) {
                newReferences.put(newColumn, newRef);
                addedColumn = true;
            } else {
                if (exists.valueType().id() == 100 && DataTypes.isArrayOfNulls(newRef.valueType())) continue;
                if (exists.valueType().id() != newRef.valueType().id()) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Column `%s` already exists with type `%s`. Cannot add same column with type `%s`", newColumn, exists.valueType().getName(), newRef.valueType().getName()));
                }
            }
            boolean addedChildren = this.addNewReferences(acquireOid, positions, newReferences, tree, newColumn);
            addedColumn = addedColumn || addedChildren;
        }
        return addedColumn;
    }

    private List<Reference> addMissingParents(List<Reference> columns) {
        ArrayList<Reference> result = new ArrayList<Reference>(columns);
        for (Reference ref : columns) {
            for (ColumnIdent parent : ref.column().parents()) {
                if (Symbols.hasColumn(result, parent)) continue;
                Reference parentRef = this.getReference(parent);
                if (parentRef == null) {
                    throw new UnsupportedOperationException("Cannot create parents of new column implicitly. `" + String.valueOf(parent) + "` is undefined");
                }
                result.add(parentRef);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public DocTableInfo addColumns(NodeContext nodeCtx, FulltextAnalyzerResolver fulltextAnalyzerResolver, LongSupplier acquireOid, List<Reference> newColumns, IntArrayList pKeyIndices, Map<String, String> newCheckConstraints) {
        void var18_22;
        List<ColumnIdent> newPrimaryKeys;
        newColumns.forEach(ref -> ref.column().validForCreate());
        DocTableInfo.checkTotalColumnsLimit(this.ident, this.tableParameters, Stream.concat(this.allColumns.values().stream(), newColumns.stream()));
        long allowedTotalColumns = TOTAL_COLUMNS_LIMIT.get(this.tableParameters);
        int numSysColumns = SysColumns.COLUMN_IDENTS.size();
        if ((long)(newColumns.size() + this.allColumns.size() - numSysColumns) > allowedTotalColumns) {
            throw new IllegalArgumentException("Limit of total columns [" + allowedTotalColumns + "] in table [" + String.valueOf(this.ident) + "] exceeded");
        }
        HashMap<ColumnIdent, Reference> newReferences = new HashMap<ColumnIdent, Reference>(this.allColumns);
        this.droppedColumns.forEach(ref -> newReferences.put(ref.column(), (Reference)ref));
        int maxPosition = this.maxPosition();
        AtomicInteger positions = new AtomicInteger(maxPosition);
        List<Reference> newColumnsWithParents = this.addMissingParents(newColumns);
        HashMap<ColumnIdent, List<Reference>> tree = Reference.buildTree(newColumnsWithParents);
        boolean addedColumn = this.addNewReferences(acquireOid, positions, newReferences, tree, null);
        if (!addedColumn) {
            return this;
        }
        Settings.Builder newSettingsBuilder = Settings.builder().put(this.tableParameters);
        for (Reference reference : newColumns) {
            IndexReference indexRef;
            String analyzer;
            if (newColumns.stream().noneMatch(r -> r.column().isChildOf(reference.column()))) {
                this.updateParentsInnerTypes(reference.column(), reference.valueType(), newReferences);
            }
            if (!(reference instanceof IndexReference) || !fulltextAnalyzerResolver.hasCustomAnalyzer(analyzer = (indexRef = (IndexReference)reference).analyzer())) continue;
            Settings settings = fulltextAnalyzerResolver.resolveFullCustomAnalyzerSettings(analyzer);
            newSettingsBuilder.put(settings);
        }
        if (pKeyIndices.isEmpty()) {
            newPrimaryKeys = this.primaryKeys;
        } else {
            newPrimaryKeys = new ArrayList<ColumnIdent>(this.primaryKeys);
            for (IntCursor cursor : pKeyIndices) {
                int pkIndex = cursor.value;
                Reference pkColumn = newColumns.get(pkIndex);
                newPrimaryKeys.add(pkColumn.column());
            }
        }
        if (newCheckConstraints.isEmpty()) {
            List<CheckConstraint<Symbol>> list = this.checkConstraints;
        } else {
            ArrayList<CheckConstraint<Symbol>> arrayList = new ArrayList<CheckConstraint<Symbol>>(this.checkConstraints);
            CoordinatorTxnCtx txnCtx = CoordinatorTxnCtx.systemTransactionContext();
            ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(txnCtx, nodeCtx, ParamTypeHints.EMPTY, new TableReferenceResolver(newReferences, this.ident), null);
            ExpressionAnalysisContext expressionAnalysisContext = new ExpressionAnalysisContext(txnCtx.sessionSettings());
            for (Map.Entry<String, String> entry : newCheckConstraints.entrySet()) {
                String name = entry.getKey();
                String expressionStr = entry.getValue();
                Expression expression = SqlParser.createExpression((String)expressionStr);
                Symbol expressionSymbol = expressionAnalyzer.convert(expression, expressionAnalysisContext);
                arrayList.add((CheckConstraint<Symbol>)new CheckConstraint(name, (Object)expressionSymbol, expressionStr));
            }
        }
        return new DocTableInfo(this.ident, newReferences, this.indexColumns, this.pkConstraintName, newPrimaryKeys, (List<CheckConstraint<Symbol>>)var18_22, this.clusteredBy, newSettingsBuilder.build(), this.partitionedBy, this.columnPolicy, this.versionCreated, this.versionUpgraded, this.closed, this.supportedOperations, this.tableVersion);
    }

    public static void checkTotalColumnsLimit(RelationName name, Settings indexSettings, Stream<Reference> columns) {
        long allowedTotalColumns;
        long numColumns = columns.filter(col -> !col.column().isSystemColumn()).count();
        if (numColumns > (allowedTotalColumns = TOTAL_COLUMNS_LIMIT.get(indexSettings).longValue())) {
            throw new IllegalArgumentException("Limit of total columns [" + allowedTotalColumns + "] in table [" + String.valueOf(name) + "] exceeded");
        }
    }
}

