/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import io.crate.metadata.sys.SysAllocationsTableInfo;
import io.crate.metadata.sys.SysChecksTableInfo;
import io.crate.metadata.sys.SysClusterTableInfo;
import io.crate.metadata.sys.SysHealth;
import io.crate.metadata.sys.SysJobsLogTableInfo;
import io.crate.metadata.sys.SysJobsTableInfo;
import io.crate.metadata.sys.SysMetricsTableInfo;
import io.crate.metadata.sys.SysNodeChecksTableInfo;
import io.crate.metadata.sys.SysNodesTableInfo;
import io.crate.metadata.sys.SysOperationsLogTableInfo;
import io.crate.metadata.sys.SysOperationsTableInfo;
import io.crate.metadata.sys.SysRepositoriesTableInfo;
import io.crate.metadata.sys.SysSegmentsTableInfo;
import io.crate.metadata.sys.SysSessionsTableInfo;
import io.crate.metadata.sys.SysShardsTableInfo;
import io.crate.metadata.sys.SysSnapshotRestoreTableInfo;
import io.crate.metadata.sys.SysSnapshotsTableInfo;
import io.crate.metadata.sys.SysSummitsTableInfo;
import io.crate.metadata.table.SchemaInfo;
import io.crate.metadata.table.TableInfo;
import io.crate.metadata.view.ViewInfo;
import io.crate.role.Roles;
import io.crate.role.metadata.SysPrivilegesTableInfo;
import io.crate.role.metadata.SysRolesTableInfo;
import io.crate.role.metadata.SysUsersTableInfo;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class SysSchemaInfo
implements SchemaInfo {
    public static final String NAME = "sys";
    private final Map<String, TableInfo> tableInfos;

    @Inject
    public SysSchemaInfo(ClusterService clusterService, Roles roles) {
        Supplier<DiscoveryNode> localNode = clusterService::localNode;
        Map.Entry[] entryArray = new Map.Entry[21];
        entryArray[0] = Map.entry(SysClusterTableInfo.IDENT.name(), SysClusterTableInfo.of(clusterService));
        entryArray[1] = Map.entry(SysNodesTableInfo.IDENT.name(), SysNodesTableInfo.INSTANCE);
        entryArray[2] = Map.entry(SysShardsTableInfo.IDENT.name(), SysShardsTableInfo.create(roles));
        entryArray[3] = Map.entry(SysJobsTableInfo.IDENT.name(), SysJobsTableInfo.create(localNode));
        entryArray[4] = Map.entry(SysJobsLogTableInfo.IDENT.name(), SysJobsLogTableInfo.create(localNode));
        entryArray[5] = Map.entry(SysOperationsTableInfo.IDENT.name(), SysOperationsTableInfo.create(localNode));
        entryArray[6] = Map.entry(SysOperationsLogTableInfo.IDENT.name(), SysOperationsLogTableInfo.INSTANCE);
        entryArray[7] = Map.entry(SysChecksTableInfo.IDENT.name(), SysChecksTableInfo.INSTANCE);
        entryArray[8] = Map.entry(SysNodeChecksTableInfo.IDENT.name(), SysNodeChecksTableInfo.INSTANCE);
        entryArray[9] = Map.entry(SysRepositoriesTableInfo.IDENT.name(), SysRepositoriesTableInfo.create(clusterService.getClusterSettings().maskedSettings()));
        entryArray[10] = Map.entry(SysSnapshotsTableInfo.IDENT.name(), SysSnapshotsTableInfo.INSTANCE);
        entryArray[11] = Map.entry(SysSnapshotRestoreTableInfo.IDENT.name(), SysSnapshotRestoreTableInfo.INSTANCE);
        entryArray[12] = Map.entry(SysSummitsTableInfo.IDENT.name(), SysSummitsTableInfo.INSTANCE);
        entryArray[13] = Map.entry(SysAllocationsTableInfo.IDENT.name(), SysAllocationsTableInfo.INSTANCE);
        entryArray[14] = Map.entry(SysHealth.IDENT.name(), SysHealth.INSTANCE);
        entryArray[15] = Map.entry(SysMetricsTableInfo.NAME.name(), SysMetricsTableInfo.create(localNode));
        entryArray[16] = Map.entry(SysSegmentsTableInfo.IDENT.name(), SysSegmentsTableInfo.create(clusterService::localNode));
        entryArray[17] = Map.entry(SysUsersTableInfo.IDENT.name(), SysUsersTableInfo.create(() -> clusterService.state().metadata().clusterUUID()));
        entryArray[18] = Map.entry(SysRolesTableInfo.IDENT.name(), SysRolesTableInfo.INSTANCE);
        entryArray[19] = Map.entry(SysPrivilegesTableInfo.IDENT.name(), SysPrivilegesTableInfo.INSTANCE);
        entryArray[20] = Map.entry(SysSessionsTableInfo.IDENT.name(), SysSessionsTableInfo.create(localNode));
        this.tableInfos = Map.ofEntries(entryArray);
    }

    @Override
    public TableInfo getTableInfo(String name) {
        return this.tableInfos.get(name);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Iterable<TableInfo> getTables() {
        return this.tableInfos.values();
    }

    @Override
    public Iterable<ViewInfo> getViews() {
        return Collections.emptyList();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void update(ClusterChangedEvent event) {
    }
}

