/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.WhereClause;
import io.crate.data.Row;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.ReaderAllocations;
import io.crate.planner.RoutingBuilder;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.costs.PlanStats;
import io.crate.planner.optimizer.tracer.LoggingOptimizerTracer;
import io.crate.planner.optimizer.tracer.OptimizerTracer;
import io.crate.protocols.postgres.TransactionState;
import io.crate.session.Cursors;
import io.crate.session.Session;
import java.util.UUID;
import java.util.function.BiFunction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.UUIDs;
import org.jetbrains.annotations.Nullable;

public class PlannerContext {
    private final UUID jobId;
    private final CoordinatorTxnCtx coordinatorTxnCtx;
    private final Cursors cursors;
    private final int fetchSize;
    private final RoutingBuilder routingBuilder;
    private final RoutingProvider routingProvider;
    private final NodeContext nodeCtx;
    private final ClusterState clusterState;
    private final TransactionState transactionState;
    private int executionPhaseId = 0;
    private final String handlerNode;
    @Nullable
    private final Row params;
    private final PlanStats planStats;
    private final OptimizerTracer optimizerTracer;
    private final BiFunction<LogicalPlan, PlannerContext, LogicalPlan> optimize;
    private final Session.TimeoutToken timeoutToken;

    public static PlannerContext forSubPlan(PlannerContext context) {
        return PlannerContext.forSubPlan(context, context.fetchSize);
    }

    public static PlannerContext forSubPlan(PlannerContext context, int fetchSize) {
        return new PlannerContext(context.clusterState, context.routingProvider, new RoutingBuilder(context.clusterState, context.routingProvider), UUIDs.dirtyUUID(), context.coordinatorTxnCtx, context.nodeCtx, fetchSize, context.params, context.cursors, context.transactionState, context.planStats, context.optimizerTracer, context.optimize, context.timeoutToken);
    }

    PlannerContext(ClusterState clusterState, RoutingProvider routingProvider, UUID jobId, CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx, int fetchSize, @Nullable Row params, Cursors cursors, TransactionState transactionState, PlanStats planStats, BiFunction<LogicalPlan, PlannerContext, LogicalPlan> optimize, Session.TimeoutToken timeoutToken) {
        this(clusterState, routingProvider, new RoutingBuilder(clusterState, routingProvider), jobId, coordinatorTxnCtx, nodeCtx, fetchSize, params, cursors, transactionState, planStats, LoggingOptimizerTracer.getInstance(), optimize, timeoutToken);
    }

    private PlannerContext(ClusterState clusterState, RoutingProvider routingProvider, RoutingBuilder routingBuilder, UUID jobId, CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx, int fetchSize, @Nullable Row params, Cursors cursors, TransactionState transactionState, PlanStats planStats, OptimizerTracer optimizerTracer, BiFunction<LogicalPlan, PlannerContext, LogicalPlan> optimize, Session.TimeoutToken timeoutToken) {
        this.routingProvider = routingProvider;
        this.nodeCtx = nodeCtx;
        this.params = params;
        this.routingBuilder = routingBuilder;
        this.clusterState = clusterState;
        this.jobId = jobId;
        this.coordinatorTxnCtx = coordinatorTxnCtx;
        this.fetchSize = fetchSize;
        this.handlerNode = clusterState.nodes().getLocalNodeId();
        this.cursors = cursors;
        this.transactionState = transactionState;
        this.planStats = planStats;
        this.optimizerTracer = optimizerTracer;
        this.optimize = optimize;
        this.timeoutToken = timeoutToken;
    }

    public PlannerContext withOptimizerTracer(OptimizerTracer optimizerTracer) {
        return new PlannerContext(this.clusterState, this.routingProvider, this.routingBuilder, this.jobId, this.coordinatorTxnCtx, this.nodeCtx, this.fetchSize, this.params, this.cursors, this.transactionState, this.planStats, optimizerTracer, this.optimize, this.timeoutToken);
    }

    @Nullable
    public Row params() {
        return this.params;
    }

    public PlanStats planStats() {
        return this.planStats;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public CoordinatorTxnCtx transactionContext() {
        return this.coordinatorTxnCtx;
    }

    public String handlerNode() {
        return this.handlerNode;
    }

    public UUID jobId() {
        return this.jobId;
    }

    public int nextExecutionPhaseId() {
        return this.executionPhaseId++;
    }

    public Routing allocateRouting(TableInfo tableInfo, WhereClause where, RoutingProvider.ShardSelection shardSelection, CoordinatorSessionSettings sessionSettings) {
        return this.routingBuilder.allocateRouting(tableInfo, where, shardSelection, sessionSettings);
    }

    public ShardRouting resolveShard(String indexName, String id, @Nullable String routing) {
        return this.routingBuilder.resolveShard(indexName, id, routing);
    }

    public ReaderAllocations buildReaderAllocations() {
        return this.routingBuilder.buildReaderAllocations();
    }

    public NodeContext nodeContext() {
        return this.nodeCtx;
    }

    public ClusterState clusterState() {
        return this.clusterState;
    }

    public void newReaderAllocations() {
        this.routingBuilder.newAllocations();
    }

    public Cursors cursors() {
        return this.cursors;
    }

    public TransactionState transactionState() {
        return this.transactionState;
    }

    public OptimizerTracer optimizerTracer() {
        return this.optimizerTracer;
    }

    public BiFunction<LogicalPlan, PlannerContext, LogicalPlan> optimize() {
        return this.optimize;
    }

    public Session.TimeoutToken timeoutToken() {
        return this.timeoutToken;
    }
}

