/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.AnalyzedSwapTable;
import io.crate.analyze.SymbolEvaluator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.ddl.RelationNameSwap;
import io.crate.execution.ddl.SwapRelationsRequest;
import io.crate.execution.support.OneRowActionListener;
import io.crate.metadata.RelationName;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.DataTypes;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.action.support.master.AcknowledgedResponse;

public class SwapTablePlan
implements Plan {
    private final AnalyzedSwapTable swapTable;

    SwapTablePlan(AnalyzedSwapTable swapTable) {
        this.swapTable = swapTable;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        boolean dropSource = Objects.requireNonNull(DataTypes.BOOLEAN.sanitizeValue(SymbolEvaluator.evaluate(plannerContext.transactionContext(), dependencies.nodeContext(), this.swapTable.dropSource(), params, subQueryResults)), "drop_source option must be true or false, not null");
        RelationName source = this.swapTable.source().ident();
        SwapRelationsRequest request = new SwapRelationsRequest(Collections.singletonList(new RelationNameSwap(source, this.swapTable.target().ident())), dropSource ? Collections.singletonList(source) : Collections.emptyList());
        OneRowActionListener<AcknowledgedResponse> listener = new OneRowActionListener<AcknowledgedResponse>(consumer, r -> r.isAcknowledged() ? new Row1((Object)1L) : new Row1((Object)0L));
        dependencies.swapRelationsAction().execute(request).whenComplete(listener);
    }
}

