/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.fetch;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.util.Map;
import java.util.TreeMap;

public final class IndexBaseBuilder {
    private final TreeMap<String, Integer> baseByIndex = new TreeMap();

    public void allocate(String index, IntIndexedContainer shards) {
        if (shards.isEmpty()) {
            return;
        }
        Integer currentMax = this.baseByIndex.get(index);
        int newMax = IndexBaseBuilder.getMax(shards);
        if (currentMax == null || currentMax < newMax) {
            this.baseByIndex.put(index, newMax);
        }
    }

    public TreeMap<String, Integer> build() {
        int currentBase = 0;
        for (Map.Entry<String, Integer> entry : this.baseByIndex.entrySet()) {
            Integer maxId = entry.getValue();
            entry.setValue(currentBase);
            currentBase += maxId + 1;
        }
        return this.baseByIndex;
    }

    private static int getMax(IntIndexedContainer shards) {
        int max = -1;
        for (IntCursor shard : shards) {
            if (shard.value <= max) continue;
            max = shard.value;
        }
        return max;
    }
}

