/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedAlterTable;
import io.crate.analyze.BoundAlterTable;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.TableParameters;
import io.crate.analyze.TableProperties;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.AlterTable;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class AlterTablePlan
implements Plan {
    final AnalyzedAlterTable alterTable;

    public AlterTablePlan(AnalyzedAlterTable alterTable) {
        this.alterTable = alterTable;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        BoundAlterTable stmt = AlterTablePlan.bind(this.alterTable, plannerContext.transactionContext(), dependencies.nodeContext(), params, subQueryResults, plannerContext.clusterState().metadata());
        dependencies.alterTableClient().setSettingsOrResize(stmt).whenComplete(new OneRowActionListener<Long>(consumer, rCount -> new Row1((Object)(rCount == null ? -1L : rCount))));
    }

    public static BoundAlterTable bind(AnalyzedAlterTable analyzedAlterTable, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row params, SubQueryResults subQueryResults, Metadata metadata) {
        TableParameters tableParameters;
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, params, subQueryResults);
        TableInfo tableInfo = analyzedAlterTable.tableInfo();
        AlterTable alterTable = analyzedAlterTable.alterTable().map(eval);
        Table table = alterTable.table();
        boolean isPartitioned = false;
        PartitionName partitionName = null;
        if (tableInfo instanceof DocTableInfo) {
            DocTableInfo docTableInfo = (DocTableInfo)tableInfo;
            partitionName = table.partitionProperties().isEmpty() ? null : PartitionName.ofAssignments(docTableInfo, table.partitionProperties(), metadata);
            isPartitioned = docTableInfo.isPartitioned();
            tableParameters = AlterTablePlan.getTableParameterInfo(table, tableInfo, partitionName);
        } else {
            assert (tableInfo.ident().schema().equals("blob")) : "If tableInfo is not a DocTableInfo, the schema must be `blob`";
            tableParameters = TableParameters.ALTER_BLOB_TABLE_PARAMETERS;
        }
        Settings.Builder settingsBuilder = AlterTablePlan.getTableParameter((AlterTable<Object>)alterTable, tableParameters);
        Settings settings = settingsBuilder.build();
        if (partitionName != null) {
            for (Setting<?> tableOnlySetting : TableParameters.TABLE_ONLY_SETTINGS) {
                if (!tableOnlySetting.exists(settings)) continue;
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Changing \"%s\" on partition level is not supported", tableOnlySetting.getKey()));
            }
        }
        AlterTablePlan.maybeRaiseBlockedException(tableInfo, settings);
        return new BoundAlterTable(tableInfo, partitionName, settings, table.excludePartitions(), isPartitioned);
    }

    private static TableParameters getTableParameterInfo(Table<?> table, TableInfo tableInfo, @Nullable PartitionName partitionName) {
        if (Operation.isReplicated(tableInfo.parameters())) {
            return TableParameters.REPLICATED_TABLE_ALTER_PARAMETER_INFO;
        }
        if (partitionName == null) {
            return TableParameters.TABLE_ALTER_PARAMETER_INFO;
        }
        assert (!table.excludePartitions()) : "Alter table ONLY not supported when using a partition";
        return TableParameters.PARTITION_PARAMETER_INFO;
    }

    private static Settings.Builder getTableParameter(AlterTable<Object> node, TableParameters tableParameters) {
        Settings.Builder settingsBuilder = Settings.builder();
        if (!node.genericProperties().isEmpty()) {
            TableProperties.analyze(settingsBuilder, tableParameters, (GenericProperties<Object>)node.genericProperties());
        } else if (!node.resetProperties().isEmpty()) {
            TableProperties.analyzeResetProperties(settingsBuilder, tableParameters, node.resetProperties());
        }
        return settingsBuilder;
    }

    static void maybeRaiseBlockedException(TableInfo tableInfo, Settings tableSettings) {
        Set<String> blockSettings = Set.of("index.blocks.metadata", "index.blocks.read", "index.blocks.write", "index.blocks.read_only");
        if (blockSettings.containsAll(tableSettings.keySet())) {
            Operation.blockedRaiseException(tableInfo, Operation.ALTER_BLOCKS);
        } else {
            Operation.blockedRaiseException(tableInfo, Operation.ALTER_SET);
        }
    }
}

