/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedCreateRole;
import io.crate.analyze.SymbolEvaluator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.role.Role;
import io.crate.role.RoleManager;
import io.crate.sql.tree.GenericProperties;
import java.util.function.Function;

public class CreateRolePlan
implements Plan {
    private final AnalyzedCreateRole createRole;
    private final RoleManager roleManager;
    private final SessionSettingRegistry sessionSettingRegistry;

    public CreateRolePlan(AnalyzedCreateRole createRole, RoleManager roleManager, SessionSettingRegistry sessionSettingRegistry) {
        this.createRole = createRole;
        this.roleManager = roleManager;
        this.sessionSettingRegistry = sessionSettingRegistry;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), x, params, subQueryResults);
        GenericProperties evaluatedProperties = this.createRole.properties().map(eval);
        Role.Properties roleProperties = Role.Properties.of(this.createRole.isUser(), false, (GenericProperties<Object>)evaluatedProperties, this.sessionSettingRegistry);
        if (!roleProperties.login() && roleProperties.password() != null) {
            throw new UnsupportedOperationException("Creating a ROLE with a password is not allowed, use CREATE USER instead");
        }
        this.roleManager.createRole(this.createRole.roleName(), this.createRole.isUser(), roleProperties.password(), roleProperties.jwtProperties()).whenComplete(new OneRowActionListener<Long>(consumer, rCount -> new Row1((Object)(rCount == null ? -1L : rCount))));
    }
}

