/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.JoinPair;
import io.crate.analyze.relations.QuerySplitter;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.SubqueryPlanner;
import io.crate.planner.operators.AbstractJoinPlan;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.JoinPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.sql.tree.JoinType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class JoinPlanBuilder {
    static LogicalPlan buildJoinTree(List<AnalyzedRelation> from, Symbol whereClause, List<JoinPair> joinPairs, SubqueryPlanner.SubQueries subQueries, Function<AnalyzedRelation, LogicalPlan> plan) {
        Symbol joinCondition;
        JoinType joinType;
        RelationName rhsName;
        RelationName lhsName;
        if (from.size() == 1) {
            LogicalPlan source = subQueries.applyCorrelatedJoin(plan.apply(from.get(0)));
            return Filter.create(source, whereClause);
        }
        Map<Set<RelationName>, Symbol> queryParts = QuerySplitter.split(whereClause);
        List<JoinPair> allJoinPairs = JoinPlanBuilder.convertImplicitJoinConditionsToJoinPairs(joinPairs, queryParts);
        LinkedHashMap<Set<RelationName>, JoinPair> joinPairsByRelations = JoinPlanBuilder.buildRelationsToJoinPairsMap(allJoinPairs);
        HashMap<RelationName, AnalyzedRelation> relationsFromClause = new HashMap<RelationName, AnalyzedRelation>();
        ArrayList<RelationName> relationNamesFromClause = new ArrayList<RelationName>();
        for (AnalyzedRelation analyzedRelation : from) {
            RelationName relationName = analyzedRelation.relationName();
            relationNamesFromClause.add(relationName);
            relationsFromClause.put(relationName, analyzedRelation);
        }
        LinkedHashSet<RelationName> joinNames = new LinkedHashSet<RelationName>();
        if (JoinPlanBuilder.containsOuterJoins(allJoinPairs)) {
            JoinPair joinPair = allJoinPairs.removeFirst();
            lhsName = joinPair.left();
            rhsName = joinPair.right();
            relationNamesFromClause.remove(lhsName);
            relationNamesFromClause.remove(rhsName);
            joinNames.add(lhsName);
            joinNames.add(rhsName);
            joinType = joinPair.joinType();
            joinCondition = joinPair.condition();
            joinPairsByRelations.remove(joinNames);
        } else {
            lhsName = (RelationName)relationNamesFromClause.removeFirst();
            rhsName = (RelationName)relationNamesFromClause.removeFirst();
            joinNames.add(lhsName);
            joinNames.add(rhsName);
            JoinPair joinLhsRhs = (JoinPair)joinPairsByRelations.remove(joinNames);
            if (joinLhsRhs == null) {
                joinType = JoinType.CROSS;
                joinCondition = null;
            } else {
                joinType = joinLhsRhs.joinType();
                joinCondition = joinLhsRhs.condition();
            }
        }
        AnalyzedRelation lhs = (AnalyzedRelation)relationsFromClause.get(lhsName);
        AnalyzedRelation rhs = (AnalyzedRelation)relationsFromClause.get(rhsName);
        CorrelatedSubQueries correlatedSubQueriesFromJoin = JoinPlanBuilder.extractCorrelatedSubQueries(joinCondition);
        Symbol validJoinConditions = AndOperator.join(correlatedSubQueriesFromJoin.remainder(), null);
        CorrelatedSubQueries correlatedSubQueriesFromWhereClause = JoinPlanBuilder.extractCorrelatedSubQueries(JoinPlanBuilder.removeParts(queryParts, lhsName, rhsName));
        Symbol validWhereConditions = AndOperator.join(correlatedSubQueriesFromWhereClause.remainder());
        boolean isFiltered = !validWhereConditions.symbolType().isValueSymbol();
        LogicalPlan joinPlan = new JoinPlan(plan.apply(lhs), plan.apply(rhs), joinType, validJoinConditions, isFiltered, false, false, AbstractJoinPlan.LookUpJoin.NONE);
        joinPlan = Filter.create(joinPlan, validWhereConditions);
        for (RelationName relationName : relationNamesFromClause) {
            AnalyzedRelation nextRel = (AnalyzedRelation)relationsFromClause.get(relationName);
            joinPlan = JoinPlanBuilder.joinWithNext(plan, joinPlan, nextRel, joinNames, joinPairsByRelations, queryParts);
            joinNames.add(nextRel.relationName());
        }
        joinPlan = subQueries.applyCorrelatedJoin(joinPlan);
        if (!queryParts.isEmpty()) {
            joinPlan = Filter.create(joinPlan, AndOperator.join(queryParts.values()));
            queryParts.clear();
        }
        joinPlan = Filter.create(joinPlan, AndOperator.join(correlatedSubQueriesFromJoin.correlatedSubQueries()));
        joinPlan = Filter.create(joinPlan, AndOperator.join(correlatedSubQueriesFromWhereClause.correlatedSubQueries()));
        assert (joinPairsByRelations.isEmpty()) : "Must've applied all joinPairs: " + String.valueOf(joinPairsByRelations);
        return joinPlan;
    }

    private static boolean containsOuterJoins(List<JoinPair> joinPairs) {
        for (JoinPair joinPair : joinPairs) {
            JoinType jt = joinPair.joinType();
            if (!jt.isOuter()) continue;
            return true;
        }
        return false;
    }

    private static LogicalPlan joinWithNext(Function<AnalyzedRelation, LogicalPlan> plan, LogicalPlan source, AnalyzedRelation nextRel, Set<RelationName> joinNames, Map<Set<RelationName>, JoinPair> joinPairs, Map<Set<RelationName>, Symbol> queryParts) {
        LogicalPlan rhs;
        LogicalPlan lhs;
        boolean isFiltered;
        JoinType type;
        RelationName nextName = nextRel.relationName();
        JoinPair joinPair = JoinPlanBuilder.removeMatch(joinPairs, joinNames, nextName);
        ArrayList<Symbol> conditions = new ArrayList<Symbol>();
        if (joinPair == null) {
            type = JoinType.CROSS;
        } else {
            JoinPair additionalJoinPair;
            type = joinPair.joinType();
            if (joinPair.condition() != null) {
                conditions.add(joinPair.condition());
            }
            while ((additionalJoinPair = JoinPlanBuilder.removeMatch(joinPairs, joinNames, nextName)) != null) {
                Symbol additionalCondition = additionalJoinPair.condition();
                if (additionalCondition == null) continue;
                conditions.add(additionalCondition);
            }
        }
        LogicalPlan nextPlan = plan.apply(nextRel);
        Symbol query = AndOperator.join(Stream.of(JoinPlanBuilder.removeMatch(queryParts, joinNames, nextName), queryParts.remove(Collections.singleton(nextName))).filter(Objects::nonNull).iterator());
        boolean bl = isFiltered = !query.symbolType().isValueSymbol();
        if (type.isOuter() && joinPair.left().equals(nextRel.relationName())) {
            lhs = nextPlan;
            rhs = source;
        } else {
            lhs = source;
            rhs = nextPlan;
        }
        JoinPlan joinPlan = new JoinPlan(lhs, rhs, type, AndOperator.join(conditions, null), isFiltered, false, false, AbstractJoinPlan.LookUpJoin.NONE);
        return Filter.create(joinPlan, query);
    }

    private static Symbol removeParts(Map<Set<RelationName>, Symbol> queryParts, RelationName lhsName, RelationName rhsName) {
        Symbol left = queryParts.remove(Collections.singleton(lhsName));
        Symbol right = queryParts.remove(Collections.singleton(rhsName));
        Symbol both = queryParts.remove(Set.of(lhsName, rhsName));
        return AndOperator.join(Stream.of(left, right, both).filter(Objects::nonNull).iterator());
    }

    @Nullable
    private static <V> V removeMatch(Map<Set<RelationName>, V> valuesByNames, Set<RelationName> names, RelationName nextName) {
        for (RelationName name : names) {
            V v = valuesByNames.remove(Set.of(name, nextName));
            if (v == null) continue;
            return v;
        }
        return null;
    }

    static List<JoinPair> convertImplicitJoinConditionsToJoinPairs(List<JoinPair> explicitJoinPairs, Map<Set<RelationName>, Symbol> implicitJoinConditions) {
        ArrayList<JoinPair> newJoinPairs = new ArrayList<JoinPair>(explicitJoinPairs);
        Iterator<Map.Entry<Set<RelationName>, Symbol>> queryIterator = implicitJoinConditions.entrySet().iterator();
        while (queryIterator.hasNext()) {
            Map.Entry<Set<RelationName>, Symbol> queryEntry = queryIterator.next();
            Set<RelationName> relations = queryEntry.getKey();
            if (relations.size() != 2) continue;
            Symbol implicitJoinCondition = queryEntry.getValue();
            boolean explicitJoinPairExists = false;
            for (JoinPair explicitJoinPair : explicitJoinPairs) {
                if (!relations.equals(Set.of(explicitJoinPair.left(), explicitJoinPair.right()))) continue;
                explicitJoinPairExists = true;
                break;
            }
            if (explicitJoinPairExists) continue;
            Iterator<RelationName> namesIter = relations.iterator();
            newJoinPairs.add(JoinPair.of(namesIter.next(), namesIter.next(), JoinType.INNER, implicitJoinCondition));
            queryIterator.remove();
        }
        return newJoinPairs;
    }

    private static LinkedHashMap<Set<RelationName>, JoinPair> buildRelationsToJoinPairsMap(List<JoinPair> joinPairs) {
        LinkedHashMap<Set<RelationName>, JoinPair> joinPairsMap = new LinkedHashMap<Set<RelationName>, JoinPair>();
        for (JoinPair joinPair : joinPairs) {
            JoinPair prevPair;
            if (joinPair.condition() == null || (prevPair = joinPairsMap.put(new LinkedHashSet<RelationName>(List.of(joinPair.left(), joinPair.right())), joinPair)) == null) continue;
            throw new IllegalStateException("joinPairs contains duplicate: " + String.valueOf(joinPair) + " matches " + String.valueOf(prevPair));
        }
        return joinPairsMap;
    }

    public static CorrelatedSubQueries extractCorrelatedSubQueries(@Nullable Symbol from) {
        if (from == null) {
            return new CorrelatedSubQueries(List.of(), List.of());
        }
        Collection<Symbol> values = QuerySplitter.split(from).values();
        ArrayList<Symbol> remainder = new ArrayList<Symbol>(values.size());
        ArrayList<Symbol> correlatedSubQueries = new ArrayList<Symbol>(values.size());
        for (Symbol symbol : values) {
            if (symbol.any(s -> {
                SelectSymbol x;
                return s instanceof SelectSymbol && (x = (SelectSymbol)s).isCorrelated();
            })) {
                correlatedSubQueries.add(symbol);
                continue;
            }
            remainder.add(symbol);
        }
        return new CorrelatedSubQueries(correlatedSubQueries, remainder);
    }

    public record CorrelatedSubQueries(List<Symbol> correlatedSubQueries, List<Symbol> remainder) {
    }
}

