/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.planner.optimizer.costs.PlanStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public final class PrintContext {
    private final StringBuilder sb;
    private final ArrayList<String> prefixes = new ArrayList();
    @Nullable
    private final PlanStats planStats;

    public PrintContext(@Nullable PlanStats planStats) {
        this.planStats = planStats;
        this.sb = new StringBuilder();
    }

    @Nullable
    public PlanStats planStats() {
        return this.planStats;
    }

    public PrintContext text(String s) {
        this.sb.append(s);
        return this;
    }

    @SafeVarargs
    public final PrintContext nest(Consumer<PrintContext> ... children) {
        return this.nest(Arrays.asList(children));
    }

    public final PrintContext nest(List<Consumer<PrintContext>> children) {
        for (int i = 0; i < children.size(); ++i) {
            this.sb.append("\n");
            for (String prefix : this.prefixes) {
                this.sb.append(prefix);
            }
            if (i + 1 == children.size()) {
                this.sb.append("  \u2514 ");
                this.prefixes.add("  ");
            } else {
                this.sb.append("  \u251c ");
                this.prefixes.add("  \u2502");
            }
            Consumer<PrintContext> child = children.get(i);
            child.accept(this);
            this.prefixes.remove(this.prefixes.size() - 1);
        }
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }
}

