/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer;

import io.crate.common.collections.Lists;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.settings.session.SessionSetting;
import io.crate.metadata.settings.session.SessionSettingProvider;
import io.crate.planner.operators.LogicalPlanner;
import io.crate.planner.optimizer.Rule;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.VisibleForTesting;

public class LoadedRules
implements SessionSettingProvider {
    private final Set<Class<? extends Rule<?>>> disabledRules;
    private final List<Class<? extends Rule<?>>> rules;
    public static final LoadedRules INSTANCE = new LoadedRules();

    private LoadedRules() {
        List<List<Rule<?>>> rules = List.of(LogicalPlanner.ITERATIVE_OPTIMIZER_RULES, LogicalPlanner.JOIN_ORDER_OPTIMIZER_RULES, LogicalPlanner.FETCH_OPTIMIZER_RULES, LogicalPlanner.WRITE_OPTIMIZER_RULES);
        this.rules = new ArrayList();
        this.disabledRules = new HashSet();
        for (Collection collection : rules) {
            for (Rule rule : collection) {
                Class<?> clazz = rule.getClass();
                if (!rule.defaultEnabled()) {
                    this.disabledRules.add(clazz);
                }
                if (rule.mandatory()) continue;
                this.rules.add(clazz);
            }
        }
    }

    @VisibleForTesting
    static SessionSetting<?> buildRuleSessionSetting(Class<? extends Rule<?>> rule) {
        String optimizerRuleName = Rule.sessionSettingName(rule);
        return new SessionSetting<Boolean>(optimizerRuleName, objects -> DataTypes.BOOLEAN.sanitizeValue(objects[0]), (sessionSettings, activateRule) -> {
            if (activateRule.booleanValue()) {
                sessionSettings.excludedOptimizerRules().remove(rule);
            } else {
                sessionSettings.excludedOptimizerRules().add(rule);
            }
        }, s -> {
            if (s instanceof CoordinatorSessionSettings) {
                CoordinatorSessionSettings cs = (CoordinatorSessionSettings)s;
                return String.valueOf(!cs.excludedOptimizerRules().contains(rule));
            }
            return "false";
        }, () -> String.valueOf(true), String.format(Locale.ENGLISH, "Indicates if the optimizer rule %s is activated.", rule.getSimpleName()), DataTypes.BOOLEAN);
    }

    public Set<Class<? extends Rule<?>>> disabledRules() {
        return this.disabledRules;
    }

    public List<Class<? extends Rule<?>>> rules() {
        return this.rules;
    }

    @Override
    public List<SessionSetting<?>> sessionSettings() {
        return Lists.map(this.rules, LoadedRules::buildRuleSessionSetting);
    }
}

