/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.iterative;

import com.carrotsearch.hppc.IntObjectHashMap;
import io.crate.common.collections.Lists;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.optimizer.iterative.GroupReference;
import io.crate.planner.optimizer.iterative.GroupReferenceResolver;
import io.crate.statistics.Stats;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class Memo {
    private static final int ROOT_GROUP_REF = 0;
    private final int rootGroup;
    private final IntObjectHashMap<Group> groups = new IntObjectHashMap();
    private int nextGroupId = 1;

    public Memo(LogicalPlan plan) {
        this.rootGroup = this.insertRecursive(plan);
        ((Group)this.groups.get((int)this.rootGroup)).incomingReferences.add(0);
    }

    public int getRootGroup() {
        return this.rootGroup;
    }

    public LogicalPlan resolve(int group) {
        return this.group((int)group).membership;
    }

    public LogicalPlan resolve(GroupReference groupReference) {
        return this.resolve(groupReference.groupId());
    }

    public LogicalPlan extract() {
        return this.extract(this.resolve(this.rootGroup));
    }

    private LogicalPlan extract(LogicalPlan node) {
        return Memo.resolveGroupReferences(node, GroupReferenceResolver.from(this::resolve));
    }

    private Group group(int group) {
        if (!this.groups.containsKey(group)) {
            throw new IllegalStateException("Group not found");
        }
        return (Group)this.groups.get(group);
    }

    public LogicalPlan replace(int groupId, LogicalPlan node) {
        Group group = this.group(groupId);
        LogicalPlan old = group.membership;
        if (node instanceof GroupReference) {
            GroupReference groupRef = (GroupReference)node;
            node = this.resolve(groupRef.groupId());
        } else {
            node = this.insertChildrenAndRewrite(node);
        }
        this.incrementReferenceCounts(node, groupId);
        group.membership = node;
        this.decrementReferenceCounts(old, groupId);
        this.evictStats(groupId);
        return node;
    }

    private void evictStats(int group) {
        this.group((int)group).stats = null;
        for (int parentGroup : this.group((int)group).incomingReferences) {
            if (parentGroup == 0) continue;
            this.evictStats(parentGroup);
        }
    }

    private void incrementReferenceCounts(LogicalPlan fromNode, int fromGroup) {
        Set<Integer> references = this.allReferences(fromNode);
        for (int group : references) {
            ((Group)this.groups.get((int)group)).incomingReferences.add(fromGroup);
        }
    }

    private void decrementReferenceCounts(LogicalPlan fromNode, Integer fromGroup) {
        Set<Integer> references = this.allReferences(fromNode);
        for (int group : references) {
            Group childGroup = (Group)this.groups.get(group);
            if (!childGroup.incomingReferences.remove(fromGroup)) {
                throw new IllegalStateException("Reference to remove not found");
            }
            if (!childGroup.incomingReferences.isEmpty()) continue;
            this.deleteGroup(group);
        }
    }

    private Set<Integer> allReferences(LogicalPlan node) {
        return node.sources().stream().map(GroupReference.class::cast).map(GroupReference::groupId).collect(Collectors.toSet());
    }

    private void deleteGroup(int group) {
        LogicalPlan deletedNode = ((Group)this.groups.remove((int)group)).membership;
        this.decrementReferenceCounts(deletedNode, group);
    }

    private LogicalPlan insertChildrenAndRewrite(LogicalPlan node) {
        return node.replaceSources(node.sources().stream().map(child -> new GroupReference(this.insertRecursive((LogicalPlan)child), child.outputs(), child.relationNames())).collect(Collectors.toList()));
    }

    private int insertRecursive(LogicalPlan node) {
        if (node instanceof GroupReference) {
            GroupReference groupReference = (GroupReference)node;
            return groupReference.groupId();
        }
        int group = this.nextGroupId();
        LogicalPlan rewritten = this.insertChildrenAndRewrite(node);
        this.groups.put(group, (Object)new Group(rewritten));
        this.incrementReferenceCounts(rewritten, group);
        return group;
    }

    private int nextGroupId() {
        return this.nextGroupId++;
    }

    public int groupCount() {
        return this.groups.size();
    }

    public static LogicalPlan resolveGroupReferences(LogicalPlan node, GroupReferenceResolver lookup) {
        Objects.requireNonNull(node, "node is null");
        return node.accept(new ResolvingVisitor(lookup), null);
    }

    public void addStats(int groupId, Stats stats) {
        Group group = this.group(groupId);
        if (group.stats != null) {
            this.evictStats(groupId);
        }
        group.stats = stats;
    }

    @Nullable
    public Stats stats(int groupId) {
        return this.group((int)groupId).stats;
    }

    private static final class Group {
        private LogicalPlan membership;
        private final List<Integer> incomingReferences = new ArrayList<Integer>();
        @Nullable
        private Stats stats;

        private Group(LogicalPlan member) {
            this.membership = Objects.requireNonNull(member, "member is null");
        }
    }

    private static class ResolvingVisitor
    extends LogicalPlanVisitor<Void, LogicalPlan> {
        private final GroupReferenceResolver lookup;

        public ResolvingVisitor(GroupReferenceResolver lookup) {
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        }

        @Override
        public LogicalPlan visitPlan(LogicalPlan node, Void context) {
            List children = Lists.mapLazy(node.sources(), child -> child.accept(this, context));
            return node.replaceSources(children);
        }

        @Override
        public LogicalPlan visitGroupReference(GroupReference node, Void context) {
            return ((LogicalPlan)this.lookup.apply(node)).accept(this, context);
        }
    }
}

