/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.common.collections.Lists;
import io.crate.execution.engine.aggregation.impl.CountAggregation;
import io.crate.expression.symbol.FieldReplacer;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.operators.Collect;
import io.crate.planner.operators.Count;
import io.crate.planner.operators.HashAggregate;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.Rename;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;

public class MergeAggregateRenameAndCollectToCount
implements Rule<HashAggregate> {
    private final Capture<Collect> collectCapture = new Capture();
    private final Capture<Rename> renameCapture = new Capture();
    private final Pattern<HashAggregate> pattern = Pattern.typeOf(HashAggregate.class).with(Patterns.source(), Pattern.typeOf(Rename.class).capturedAs(this.renameCapture).with(Patterns.source(), Pattern.typeOf(Collect.class).capturedAs(this.collectCapture).with(collect -> collect.relation().tableInfo() instanceof DocTableInfo))).with(aggregate -> aggregate.aggregates().size() == 1 && aggregate.aggregates().get(0).signature().equals(CountAggregation.COUNT_STAR_SIGNATURE));

    @Override
    public Pattern<HashAggregate> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(HashAggregate aggregate, Captures captures, Rule.Context context) {
        Collect collect = captures.get(this.collectCapture);
        Rename rename = captures.get(this.renameCapture);
        Function countAggregate = (Function)Lists.getOnlyElement(aggregate.aggregates());
        Symbol filter = countAggregate.filter();
        if (filter != null) {
            Symbol mappedFilter = FieldReplacer.replaceFields(filter, rename::resolveField);
            return new Count(countAggregate, collect.relation(), collect.where().add(mappedFilter));
        }
        return new Count(countAggregate, collect.relation(), collect.where());
    }
}

