/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.QuerySplitter;
import io.crate.common.collections.Sets;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.operators.AbstractJoinPlan;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.sql.tree.JoinType;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class MoveFilterBeneathJoin
implements Rule<Filter> {
    private final Capture<AbstractJoinPlan> joinCapture = new Capture();
    private final Pattern<Filter> pattern = Pattern.typeOf(Filter.class).with(Patterns.source(), Pattern.typeOf(AbstractJoinPlan.class).capturedAs(this.joinCapture).with(join -> SUPPORTED_JOIN_TYPES.contains(join.joinType())));
    private static final Set<JoinType> SUPPORTED_JOIN_TYPES = EnumSet.of(JoinType.INNER, JoinType.LEFT, JoinType.RIGHT, JoinType.CROSS);

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter filter, Captures captures, Rule.Context context) {
        AbstractJoinPlan join = captures.get(this.joinCapture);
        Symbol query = filter.query();
        if (!WhereClause.canMatch(query)) {
            return join.replaceSources(List.of(MoveFilterBeneathJoin.getNewSource(query, join.lhs()), MoveFilterBeneathJoin.getNewSource(query, join.rhs())));
        }
        Map<Set<RelationName>, Symbol> splitQueries = QuerySplitter.split(query);
        int initialParts = splitQueries.size();
        if (splitQueries.size() == 1 && splitQueries.keySet().iterator().next().size() > 1) {
            return null;
        }
        LogicalPlan lhs = join.lhs();
        LogicalPlan rhs = join.rhs();
        HashSet<RelationName> lhsRelations = new HashSet<RelationName>(lhs.relationNames());
        HashSet<RelationName> rhsRelations = new HashSet<RelationName>(rhs.relationNames());
        Symbol leftQuery = splitQueries.remove(lhsRelations);
        Symbol rightQuery = splitQueries.remove(rhsRelations);
        if (leftQuery == null && rightQuery == null) {
            Iterator<Map.Entry<Set<RelationName>, Symbol>> it = splitQueries.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Set<RelationName>, Symbol> entry = it.next();
                Set<RelationName> relationNames = entry.getKey();
                Symbol splitQuery = entry.getValue();
                Set matchesLhs = Sets.intersection(lhsRelations, relationNames);
                Set matchesRhs = Sets.intersection(rhsRelations, relationNames);
                if (!matchesRhs.isEmpty() && matchesLhs.isEmpty()) {
                    rightQuery = rightQuery == null ? splitQuery : AndOperator.of(rightQuery, splitQuery);
                    it.remove();
                    continue;
                }
                if (!matchesRhs.isEmpty() || matchesLhs.isEmpty()) continue;
                leftQuery = leftQuery == null ? splitQuery : AndOperator.of(leftQuery, splitQuery);
                it.remove();
            }
        }
        LogicalPlan newLhs = lhs;
        LogicalPlan newRhs = rhs;
        JoinType joinType = join.joinType();
        if (joinType == JoinType.INNER || joinType == JoinType.CROSS) {
            newLhs = MoveFilterBeneathJoin.getNewSource(leftQuery, lhs);
            newRhs = MoveFilterBeneathJoin.getNewSource(rightQuery, rhs);
        } else if (joinType == JoinType.LEFT) {
            newLhs = MoveFilterBeneathJoin.getNewSource(leftQuery, lhs);
            if (rightQuery != null) {
                splitQueries.put(rhsRelations, rightQuery);
            }
        } else if (joinType == JoinType.RIGHT) {
            newRhs = MoveFilterBeneathJoin.getNewSource(rightQuery, rhs);
            if (leftQuery != null) {
                splitQueries.put(lhsRelations, leftQuery);
            }
        }
        if (newLhs == lhs && newRhs == rhs) {
            return null;
        }
        LogicalPlan newJoin = join.replaceSources(List.of(newLhs, newRhs));
        if (splitQueries.isEmpty()) {
            return newJoin;
        }
        if (initialParts == splitQueries.size()) {
            return null;
        }
        return new Filter(newJoin, AndOperator.join(splitQueries.values()));
    }

    static LogicalPlan getNewSource(@Nullable Symbol splitQuery, LogicalPlan source) {
        return splitQuery == null ? source : new Filter(source, splitQuery);
    }
}

