/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.WindowDefinition;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.WindowFunction;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanner;
import io.crate.planner.operators.WindowAgg;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.planner.optimizer.rule.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class MoveFilterBeneathWindowAgg
implements Rule<Filter> {
    private final Capture<WindowAgg> windowAggCapture = new Capture();
    private final Pattern<Filter> pattern = Pattern.typeOf(Filter.class).with(Patterns.source(), Pattern.typeOf(WindowAgg.class).capturedAs(this.windowAggCapture));

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter filter, Captures captures, Rule.Context context) {
        WindowAgg windowAgg = captures.get(this.windowAggCapture);
        WindowDefinition windowDefinition = windowAgg.windowDefinition();
        List<WindowFunction> windowFunctions = windowAgg.windowFunctions();
        Predicate<Symbol> containsWindowFunction = symbol -> symbol instanceof WindowFunction && windowFunctions.contains(symbol);
        Symbol predicate = filter.query();
        List<Symbol> filterParts = AndOperator.split(predicate);
        ArrayList<Symbol> remainingFilterSymbols = new ArrayList<Symbol>();
        ArrayList<Symbol> windowPartitionedBasedFilters = new ArrayList<Symbol>();
        for (Symbol part : filterParts) {
            if (!part.any(containsWindowFunction) && windowDefinition.partitions().containsAll(LogicalPlanner.extractColumns(part))) {
                windowPartitionedBasedFilters.add(part);
                continue;
            }
            remainingFilterSymbols.add(part);
        }
        assert (!remainingFilterSymbols.isEmpty() || !windowPartitionedBasedFilters.isEmpty()) : "Splitting the filter symbol must result in at least one group";
        if (windowPartitionedBasedFilters.isEmpty()) {
            return null;
        }
        if (remainingFilterSymbols.isEmpty()) {
            return Util.transpose(filter, windowAgg);
        }
        LogicalPlan newWindowAgg = windowAgg.replaceSources(List.of(new Filter(windowAgg.source(), AndOperator.join(windowPartitionedBasedFilters))));
        return new Filter(newWindowAgg, AndOperator.join(remainingFilterSymbols));
    }
}

