/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.planner.operators.GroupHashAggregate;
import io.crate.planner.operators.Limit;
import io.crate.planner.operators.LimitDistinct;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.costs.PlanStats;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.statistics.Stats;
import io.crate.types.DataTypes;
import org.elasticsearch.Version;

public final class RewriteGroupByKeysLimitToLimitDistinct
implements Rule<Limit> {
    private final Pattern<Limit> pattern;
    private final Capture<GroupHashAggregate> groupCapture = new Capture();

    public RewriteGroupByKeysLimitToLimitDistinct() {
        this.pattern = Pattern.typeOf(Limit.class).with(Patterns.source(), Pattern.typeOf(GroupHashAggregate.class).capturedAs(this.groupCapture).with(groupAggregate -> groupAggregate.aggregates().isEmpty()));
    }

    private static boolean eagerTerminateIsLikely(Limit limit, GroupHashAggregate groupAggregate, PlanStats planStats) {
        double threshold;
        Integer limitVal;
        if (groupAggregate.outputs().size() > 1 || !groupAggregate.outputs().get(0).valueType().equals(DataTypes.STRING)) {
            return true;
        }
        Stats groupHashAggregateStats = planStats.get(groupAggregate);
        Symbol limitSymbol = limit.limit();
        if (limitSymbol instanceof Literal && (long)(limitVal = DataTypes.INTEGER.sanitizeValue(((Literal)limitSymbol).value())).intValue() > groupHashAggregateStats.numDocs()) {
            return false;
        }
        long sourceRows = planStats.get(groupAggregate.source()).numDocs();
        if (sourceRows == 0L) {
            return false;
        }
        long cardinalityRatio = groupHashAggregateStats.numDocs() / sourceRows;
        return (double)cardinalityRatio > (threshold = 0.001);
    }

    @Override
    public Pattern<Limit> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Limit limit, Captures captures, Rule.Context context) {
        GroupHashAggregate groupBy = captures.get(this.groupCapture);
        if (!RewriteGroupByKeysLimitToLimitDistinct.eagerTerminateIsLikely(limit, groupBy, context.planStats())) {
            return null;
        }
        return new LimitDistinct(groupBy.source(), limit.limit(), limit.offset(), groupBy.outputs());
    }

    @Override
    public Version requiredVersion() {
        return Version.V_4_1_0;
    }
}

