/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.statement;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import io.crate.analyze.AnalyzedCopyFrom;
import io.crate.analyze.AnalyzedCopyFromReturnSummary;
import io.crate.analyze.BoundCopyFrom;
import io.crate.analyze.CopyFromParserProperties;
import io.crate.analyze.CopyStatementSettings;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.copy.NodeFilters;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.dsl.phases.FileUriCollectPhase;
import io.crate.execution.dsl.phases.NodeOperationTree;
import io.crate.execution.dsl.projection.AbstractIndexWriterProjection;
import io.crate.execution.dsl.projection.MergeCountProjection;
import io.crate.execution.dsl.projection.SourceIndexWriterProjection;
import io.crate.execution.dsl.projection.SourceIndexWriterReturnSummaryProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.engine.JobLauncher;
import io.crate.execution.engine.NodeOperationTreeGenerator;
import io.crate.expression.reference.file.SourceLineNumberExpression;
import io.crate.expression.reference.file.SourceParsingFailureExpression;
import io.crate.expression.reference.file.SourceUriExpression;
import io.crate.expression.reference.file.SourceUriFailureExpression;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.node.dql.Collect;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.GenericProperties;
import io.crate.types.DataTypes;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class CopyFromPlan
implements Plan {
    private final AnalyzedCopyFrom copyFrom;

    public CopyFromPlan(AnalyzedCopyFrom copyFrom) {
        this.copyFrom = copyFrom;
    }

    public AnalyzedCopyFrom copyFrom() {
        return this.copyFrom;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.COPY;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        BoundCopyFrom boundedCopyFrom = CopyFromPlan.bind(this.copyFrom, plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults);
        ExecutionPlan plan = CopyFromPlan.planCopyFromExecution(this.copyFrom, boundedCopyFrom, dependencies.clusterService().state().nodes(), plannerContext);
        NodeOperationTree nodeOpTree = NodeOperationTreeGenerator.fromPlan(plan, dependencies.localNodeId());
        JobLauncher jobLauncher = dependencies.phasesTaskFactory().create(plannerContext.jobId(), List.of(nodeOpTree));
        jobLauncher.execute(consumer, plannerContext.transactionContext(), CopyStatementSettings.WAIT_FOR_COMPLETION_SETTING.get(boundedCopyFrom.settings()));
    }

    @VisibleForTesting
    public static BoundCopyFrom bind(AnalyzedCopyFrom copyFrom, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, parameters, subQueryResults);
        PartitionName partitionName = copyFrom.table().partitionProperties().isEmpty() ? null : PartitionName.ofAssignmentsUnsafe(copyFrom.tableInfo(), Lists.map((Collection)copyFrom.table().partitionProperties(), x -> x.map(eval)));
        String partitionIdent = partitionName == null ? null : partitionName.ident();
        GenericProperties properties = copyFrom.properties().map(eval);
        Predicate<DiscoveryNode> nodeFiltersPredicate = CopyFromPlan.discoveryNodePredicate(properties.get("node_filters", null));
        Settings settings = Settings.builder().put((GenericProperties<Object>)properties).build();
        boolean returnSummary = copyFrom instanceof AnalyzedCopyFromReturnSummary;
        boolean waitForCompletion = CopyStatementSettings.WAIT_FOR_COMPLETION_SETTING.get(settings);
        if (!waitForCompletion && returnSummary) {
            throw new UnsupportedOperationException("Cannot use RETURN SUMMARY with wait_for_completion=false. Either set wait_for_completion=true, or remove RETURN SUMMARY");
        }
        FileUriCollectPhase.InputFormat inputFormat = CopyStatementSettings.settingAsEnum(FileUriCollectPhase.InputFormat.class, settings.get(CopyStatementSettings.INPUT_FORMAT_SETTING.getKey(), CopyStatementSettings.INPUT_FORMAT_SETTING.getDefault(Settings.EMPTY)));
        Literal<?> boundedURI = CopyFromPlan.validateAndConvertToLiteral(eval.apply(copyFrom.uri()), (GenericProperties<Object>)properties);
        Boolean header = settings.getAsBoolean("header", true);
        List targetColumns = copyFrom.targetColumns();
        if (!header.booleanValue() && copyFrom.targetColumns().isEmpty()) {
            targetColumns = Lists.map((Collection)copyFrom.tableInfo().columns(), (Function<Reference, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/metadata/Reference;)Ljava/lang/String;)());
        }
        return new BoundCopyFrom(copyFrom.tableInfo(), partitionIdent, targetColumns, settings, boundedURI, inputFormat, nodeFiltersPredicate);
    }

    public static ExecutionPlan planCopyFromExecution(AnalyzedCopyFrom copyFrom, BoundCopyFrom boundedCopyFrom, DiscoveryNodes allNodes, PlannerContext context) {
        Integer numReaders;
        SourceIndexWriterProjection sourceIndexWriterProjection;
        ColumnIdent clusteredBy;
        DocTableInfo table = boundedCopyFrom.tableInfo();
        String partitionIdent = boundedCopyFrom.partitionIdent();
        List partitionedByNames = Collections.emptyList();
        List<String> partitionValues = Collections.emptyList();
        if (partitionIdent == null) {
            if (table.isPartitioned()) {
                partitionedByNames = Lists.map(table.partitionedBy(), ColumnIdent::fqn);
            }
        } else {
            assert (table.isPartitioned()) : "table must be partitioned if partitionIdent is set";
            partitionValues = PartitionName.decodeIdent(partitionIdent);
        }
        if (SysColumns.ID.COLUMN.equals(clusteredBy = table.clusteredBy())) {
            clusteredBy = null;
        }
        List<Reference> primaryKeyRefs = table.primaryKey().stream().filter(r -> !r.equals(SysColumns.ID.COLUMN)).map(table::getReference).toList();
        List<Symbol> toCollect = CopyFromPlan.getSymbolsRequiredForShardIdCalc(primaryKeyRefs, table.partitionedByColumns(), clusteredBy == null ? null : table.getReference(clusteredBy));
        Reference rawOrDoc = CopyFromPlan.rawOrDoc(table, partitionIdent);
        int rawOrDocIdx = toCollect.size();
        toCollect.add(rawOrDoc);
        String[] excludes = !partitionedByNames.isEmpty() ? partitionedByNames.toArray(new String[0]) : null;
        InputColumns.SourceSymbols sourceSymbols = new InputColumns.SourceSymbols(toCollect);
        Symbol clusteredByInputCol = null;
        if (clusteredBy != null) {
            clusteredByInputCol = InputColumns.create((Symbol)table.getReference(clusteredBy), sourceSymbols);
        }
        List<? extends Symbol> projectionOutputs = AbstractIndexWriterProjection.OUTPUTS;
        if (copyFrom instanceof AnalyzedCopyFromReturnSummary) {
            AnalyzedCopyFromReturnSummary returnSummary = (AnalyzedCopyFromReturnSummary)copyFrom;
            InputColumn sourceUriSymbol = new InputColumn(toCollect.size(), DataTypes.STRING);
            toCollect.add(SourceUriExpression.getReferenceForRelation(table.ident()));
            InputColumn sourceUriFailureSymbol = new InputColumn(toCollect.size(), DataTypes.STRING);
            toCollect.add(SourceUriFailureExpression.getReferenceForRelation(table.ident()));
            InputColumn lineNumberSymbol = new InputColumn(toCollect.size(), DataTypes.LONG);
            toCollect.add(SourceLineNumberExpression.getReferenceForRelation(table.ident()));
            InputColumn sourceParsingFailureSymbol = new InputColumn(toCollect.size(), DataTypes.STRING);
            toCollect.add(SourceParsingFailureExpression.getReferenceForRelation(table.ident()));
            List<Symbol> fields = returnSummary.outputs();
            projectionOutputs = InputColumns.create(fields, new InputColumns.SourceSymbols(fields));
            sourceIndexWriterProjection = new SourceIndexWriterReturnSummaryProjection(table.ident(), partitionIdent, table.getReference(SysColumns.RAW), new InputColumn(rawOrDocIdx, rawOrDoc.valueType()), table.primaryKey(), InputColumns.create(table.partitionedByColumns(), sourceSymbols), clusteredBy, boundedCopyFrom.settings(), excludes, InputColumns.create(primaryKeyRefs, sourceSymbols), clusteredByInputCol, projectionOutputs, table.isPartitioned(), sourceUriSymbol, sourceUriFailureSymbol, sourceParsingFailureSymbol, lineNumberSymbol);
        } else {
            sourceIndexWriterProjection = new SourceIndexWriterProjection(table.ident(), partitionIdent, table.getReference(SysColumns.RAW), new InputColumn(rawOrDocIdx, rawOrDoc.valueType()), table.primaryKey(), InputColumns.create(table.partitionedByColumns(), sourceSymbols), clusteredBy, boundedCopyFrom.settings(), excludes, InputColumns.create(primaryKeyRefs, sourceSymbols), clusteredByInputCol, projectionOutputs, table.isPartitioned());
        }
        if (partitionValues != null) {
            CopyFromPlan.rewriteToCollectToUsePartitionValues(table.partitionedByColumns(), partitionValues, toCollect);
        }
        numReaders = (numReaders = CopyStatementSettings.NUM_READERS_SETTING.getOrNull(boundedCopyFrom.settings())) == null ? allNodes.getSize() : numReaders.intValue();
        FileUriCollectPhase collectPhase = new FileUriCollectPhase(context.jobId(), context.nextExecutionPhaseId(), "copyFrom", CopyFromPlan.getExecutionNodes(allNodes, numReaders, boundedCopyFrom.nodePredicate()), boundedCopyFrom.uri(), boundedCopyFrom.targetColumns(), toCollect, Collections.emptyList(), CopyStatementSettings.COMPRESSION_SETTING.getOrNull(boundedCopyFrom.settings()), CopyStatementSettings.SHARED_SETTING.getOrNull(boundedCopyFrom.settings()), CopyFromParserProperties.of(boundedCopyFrom.settings()), boundedCopyFrom.inputFormat(), boundedCopyFrom.settings());
        Collect collect = new Collect(collectPhase, -1, 0, 1, -1, null);
        collect.addProjection(sourceIndexWriterProjection);
        List<Object> handlerProjections = copyFrom instanceof AnalyzedCopyFromReturnSummary ? Collections.emptyList() : List.of(MergeCountProjection.INSTANCE);
        return Merge.ensureOnHandler(collect, context, handlerProjections);
    }

    private static void rewriteToCollectToUsePartitionValues(List<Reference> partitionedByColumns, List<String> partitionValues, List<Symbol> toCollect) {
        for (int i = 0; i < partitionValues.size(); ++i) {
            int idx;
            Reference partitionedByColumn = partitionedByColumns.get(i);
            if (partitionedByColumn instanceof GeneratedReference) {
                GeneratedReference genRef = (GeneratedReference)partitionedByColumn;
                idx = toCollect.indexOf(genRef.generatedExpression());
            } else {
                idx = toCollect.indexOf(partitionedByColumn);
            }
            if (idx <= -1) continue;
            toCollect.set(idx, Literal.of(partitionValues.get(i)));
        }
    }

    private static List<Symbol> getSymbolsRequiredForShardIdCalc(List<Reference> primaryKeyRefs, List<Reference> partitionedByRefs, @Nullable Reference clusteredBy) {
        HashSet<Symbol> toCollectUnique = new HashSet<Symbol>();
        primaryKeyRefs.forEach(r -> CopyFromPlan.addWithRefDependencies(toCollectUnique, r));
        partitionedByRefs.forEach(r -> CopyFromPlan.addWithRefDependencies(toCollectUnique, r));
        if (clusteredBy != null) {
            CopyFromPlan.addWithRefDependencies(toCollectUnique, clusteredBy);
        }
        return new ArrayList<Symbol>(toCollectUnique);
    }

    private static void addWithRefDependencies(HashSet<Symbol> toCollectUnique, Reference ref) {
        if (ref instanceof GeneratedReference) {
            GeneratedReference generatedReference = (GeneratedReference)ref;
            toCollectUnique.add(generatedReference.generatedExpression());
        } else {
            toCollectUnique.add(ref);
        }
    }

    private static Reference rawOrDoc(DocTableInfo table, String selectedPartitionIdent) {
        if (table.isPartitioned() && selectedPartitionIdent == null) {
            return table.getReference(SysColumns.DOC);
        }
        return table.getReference(SysColumns.RAW);
    }

    private static Collection<String> getExecutionNodes(DiscoveryNodes allNodes, int maxNodes, Predicate<DiscoveryNode> nodeFilters) {
        int counter = maxNodes;
        ArrayList<String> nodes = new ArrayList<String>(allNodes.getSize());
        for (ObjectCursor cursor : allNodes.getDataNodes().values()) {
            if (!nodeFilters.test((DiscoveryNode)cursor.value) || counter-- <= 0) continue;
            nodes.add(((DiscoveryNode)cursor.value).getId());
        }
        return nodes;
    }

    private static Literal<?> validateAndConvertToLiteral(Object uri, GenericProperties<Object> properties) {
        if (uri instanceof String) {
            String uriAsString = DataTypes.STRING.sanitizeValue(uri);
            if (uriAsString.startsWith("/") || uriAsString.startsWith("file:")) {
                properties.ensureContainsOnly(CopyStatementSettings.COMMON_COPY_FROM_SETTINGS);
            }
            return Literal.of(uriAsString);
        }
        if (uri instanceof List) {
            List uris = (List)uri;
            Object value = uris.get(0);
            if (!(value instanceof String)) {
                throw AnalyzedCopyFrom.raiseInvalidType(DataTypes.guessType(uri));
            }
            String uriAsString = (String)value;
            if (uriAsString.startsWith("/") || uriAsString.startsWith("file:")) {
                properties.ensureContainsOnly(CopyStatementSettings.COMMON_COPY_FROM_SETTINGS);
            }
            return Literal.of(DataTypes.STRING_ARRAY, DataTypes.STRING_ARRAY.sanitizeValue(uri));
        }
        throw AnalyzedCopyFrom.raiseInvalidType(DataTypes.guessType(uri));
    }

    private static Predicate<DiscoveryNode> discoveryNodePredicate(@Nullable Object nodeFilter) {
        if (nodeFilter == null) {
            return ignoredDiscoveryNode -> true;
        }
        try {
            return NodeFilters.fromMap((Map)nodeFilter);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid parameter passed to %s. Expected an object with name or id keys and string values. Got '%s'", "node_filters", nodeFilter));
        }
    }
}

