/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.statement;

import io.crate.analyze.SymbolEvaluator;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.settings.CrateSettings;
import io.crate.metadata.settings.session.SessionSetting;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.Assignment;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.VisibleForTesting;

public class SetSessionPlan
implements Plan {
    private static final Logger LOGGER = LogManager.getLogger(SetSessionPlan.class);
    private final List<Assignment<Symbol>> settings;
    private final SessionSettingRegistry sessionSettingRegistry;

    public SetSessionPlan(List<Assignment<Symbol>> settings, SessionSettingRegistry sessionSettingRegistry) {
        this.settings = settings;
        this.sessionSettingRegistry = sessionSettingRegistry;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.MANAGEMENT;
    }

    @Override
    public void executeOrFail(DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), x, params, subQueryResults);
        CoordinatorSessionSettings sessionSettings = plannerContext.transactionContext().sessionSettings();
        Assignment<Symbol> assignment = this.settings.get(0);
        String settingName = eval.apply((Symbol)assignment.columnName()).toString();
        SessionSetting<?> sessionSetting = this.sessionSettingRegistry.settings().get(settingName);
        if (sessionSetting == null) {
            LOGGER.info("SET SESSION STATEMENT WILL BE IGNORED: {}", (Object)settingName);
            SetSessionPlan.ensureNotGlobalSetting(settingName);
        } else if (assignment.expressions().isEmpty()) {
            sessionSetting.apply(sessionSettings, sessionSetting.defaultValue());
        } else {
            sessionSetting.apply(sessionSettings, assignment.expressions(), eval);
        }
        consumer.accept(InMemoryBatchIterator.empty((Object)SentinelRow.SENTINEL), null);
    }

    @VisibleForTesting
    static void ensureNotGlobalSetting(String settingName) {
        List<String> nameParts = CrateSettings.settingNamesByPrefix(settingName);
        if (!nameParts.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "GLOBAL Cluster setting '%s' cannot be used with SET SESSION / LOCAL", settingName));
        }
    }
}

