/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class ConnectionStats
implements Writeable {
    private final long open;
    private final long total;
    private final long receivedMessages;
    private final long receivedBytes;
    private final long sentMessages;
    private final long sentBytes;

    public ConnectionStats(long open, long total, long receivedMessages, long receivedBytes, long sentMessages, long sentBytes) {
        this.open = open;
        this.total = total;
        this.receivedMessages = receivedMessages;
        this.receivedBytes = receivedBytes;
        this.sentMessages = sentMessages;
        this.sentBytes = sentBytes;
    }

    public ConnectionStats(StreamInput in) throws IOException {
        this.open = in.readVLong();
        this.total = in.readVLong();
        this.receivedMessages = in.readVLong();
        this.receivedBytes = in.readVLong();
        this.sentMessages = in.readVLong();
        this.sentBytes = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.open);
        out.writeVLong(this.total);
        out.writeVLong(this.receivedMessages);
        out.writeVLong(this.receivedBytes);
        out.writeVLong(this.sentMessages);
        out.writeVLong(this.sentBytes);
    }

    public long open() {
        return this.open;
    }

    public long total() {
        return this.total;
    }

    public long receivedMsgs() {
        return this.receivedMessages;
    }

    public long receivedBytes() {
        return this.receivedBytes;
    }

    public long sentMsgs() {
        return this.sentMessages;
    }

    public long sentBytes() {
        return this.sentBytes;
    }
}

