/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.auth.AuthenticationMethod;
import io.crate.auth.Credentials;
import io.crate.protocols.postgres.ConnectionProperties;
import io.crate.role.Role;
import java.io.Closeable;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.SecureString;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

class AuthenticationContext
implements Closeable {
    private final Credentials credentials;
    private final Logger logger;
    private final AuthenticationMethod authMethod;
    private final ConnectionProperties connProperties;

    AuthenticationContext(AuthenticationMethod authMethod, ConnectionProperties connProperties, Credentials credentials, Logger logger) {
        this.authMethod = authMethod;
        this.connProperties = connProperties;
        this.credentials = credentials;
        this.logger = logger;
    }

    @Nullable
    Role authenticate() {
        Role user = this.authMethod.authenticate(this.credentials, this.connProperties);
        if (user != null && this.logger.isTraceEnabled()) {
            this.logger.trace("Authentication succeeded user \"{}\" and method \"{}\".", (Object)user.name(), (Object)this.authMethod.name());
        }
        return user;
    }

    void setSecurePassword(char[] secureString) {
        this.credentials.setPassword(secureString);
    }

    @Nullable
    @VisibleForTesting
    SecureString password() {
        return this.credentials.password();
    }

    ConnectionProperties connectionProperties() {
        return this.connProperties;
    }

    @Override
    public void close() {
        if (this.credentials != null) {
            this.credentials.close();
        }
    }
}

