/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import io.crate.auth.Credentials;
import io.crate.auth.Protocol;
import java.net.InetAddress;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.jetbrains.annotations.Nullable;

public class ConnectionProperties {
    private final InetAddress address;
    private final Protocol protocol;
    private final boolean hasSSL;
    private final List<ClientMethod> clientMethods;
    private final Certificate certificate;

    public ConnectionProperties(@Nullable Credentials credentials, InetAddress address, Protocol protocol, @Nullable SSLSession sslSession) {
        this.address = address;
        this.protocol = protocol;
        this.hasSSL = sslSession != null;
        Certificate cert = null;
        if (sslSession != null) {
            try {
                cert = sslSession.getPeerCertificates()[0];
            }
            catch (ArrayIndexOutOfBoundsException | SSLPeerUnverifiedException e) {
                cert = null;
            }
        }
        this.certificate = cert;
        this.clientMethods = new ArrayList<ClientMethod>();
        this.clientMethods.add(ClientMethod.TRUST);
        if (this.certificate != null) {
            this.clientMethods.add(ClientMethod.CERT);
        }
        if (credentials != null) {
            if (credentials.password() != null || Protocol.POSTGRES.equals((Object)protocol)) {
                this.clientMethods.add(ClientMethod.PASSWORD);
            }
            if (credentials.decodedToken() != null) {
                this.clientMethods.add(ClientMethod.JWT);
            }
        }
    }

    public List<ClientMethod> clientMethods() {
        return this.clientMethods;
    }

    public boolean hasSSL() {
        return this.hasSSL;
    }

    public InetAddress address() {
        return this.address;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    @Nullable
    public Certificate clientCert() {
        return this.certificate;
    }

    public static enum ClientMethod {
        CERT,
        PASSWORD,
        JWT,
        TRUST;

    }
}

